/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.duals;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.cuf.common.documents.DocumentClassDto;
import com.suncode.cuf.common.documents.duals.parameters.UploadDocumentFromDiskParameters;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-pwe/upload-document-from-disk-dual-form.js")
public class UploadDocumentFromDisk {
    @Autowired
    private CUFCommonDocumentService documentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("upload-document-from-disk.dual")).name("dual-app-set.upload-document-from-disk.name")).description("dual-app-set.upload-document-from-disk.desc")).category(new Category[]{Categories.DOCUMENTS})).icon((Icon)SilkIconPack.PAGE_ADD)).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}adding-a-document-from-disk-application")).parameter().id("pathType").name("dual-app-set.upload-document-from-disk.path-type.name").description("dual-app-set.upload-document-from-disk.path-type.desc").type((Type)Types.STRING).defaultValue((Object)"FILE").create()).parameter().id("pathname").name("dual-app-set.upload-document-from-disk.filePath.name").description("dual-app-set.upload-document-from-disk.filePath.desc").type((Type)Types.STRING).optional().create()).parameter().id("directoryPath").name("dual-app-set.upload-document-from-disk.directory-path.name").description("dual-app-set.upload-document-from-disk.directory-path.desc").type((Type)Types.STRING).optional().create()).parameter().id("fileNameFilter").name("dual-app-set.upload-document-from-disk.file-name-filter.name").description("dual-app-set.upload-document-from-disk.file-name-filter.desc").type((Type)Types.STRING).optional().create()).parameter().id("searchSubdirectories").name("dual-app-set.upload-document-from-disk.search-subdirectories.name").description("dual-app-set.upload-document-from-disk.search-subdirectories.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)false).create()).parameter().id("docClassName").name("dual-app-set.upload-document-from-disk.docClassName.name").description("dual-app-set.upload-document-from-disk.docClassName.desc").type((Type)Types.STRING).create()).parameter().id("indexesName").name("dual-app-set.upload-document-from-disk.indexesName.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("indexesValue").name("dual-app-set.upload-document-from-disk.indexesValue.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("documentDescription").name("dual-app-set.upload-document-from-disk.documentDescription.name").description("dual-app-set.upload-document-from-disk.documentDescription.desc").type((Type)Types.STRING).optional().create()).parameter().id("saveAsNewVersion").name("dual-app-set.upload-document-from-disk.saveAsNewVersion.name").description("dual-app-set.upload-document-from-disk.saveAsNewVersion.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("attachToProcess").name("dual-app-set.upload-document-from-disk.attachToProcess.name").description("dual-app-set.upload-document-from-disk.attachToProcess.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("runDocClassAction").name("dual-app-set.upload-document-from-disk.runDocClassAction.name").description("dual-app-set.upload-document-from-disk.runDocClassAction.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create();
    }

    public void execute(Parameters parameters, ApplicationContext context) {
        this.run(parameters, (WorkflowContext)context);
    }

    public void set(Parameters parameters, AcceptanceContext context) {
        this.run(parameters, (WorkflowContext)context);
    }

    public void run(Parameters parameters, WorkflowContext context) {
        UploadDocumentFromDiskParameters applicationSetterParameters = new UploadDocumentFromDiskParameters(parameters);
        switch (applicationSetterParameters.getPathType()) {
            case "FILE": {
                this.addSingleFileToArchive(applicationSetterParameters, context);
                break;
            }
            case "DIRECTORY": {
                this.addMultipleFilesToArchive(applicationSetterParameters, context);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid path type: " + applicationSetterParameters.getPathType());
            }
        }
    }

    private void addSingleFileToArchive(UploadDocumentFromDiskParameters applicationSetterParameters, WorkflowContext context) {
        File file = this.getFile(applicationSetterParameters.getPathname());
        this.addFileToArchive(file, applicationSetterParameters, context);
    }

    private void addMultipleFilesToArchive(UploadDocumentFromDiskParameters applicationSetterParameters, WorkflowContext context) {
        List<File> files;
        Path directoryPath = Paths.get(applicationSetterParameters.getDirectoryPath(), new String[0]);
        Assert.isTrue((boolean)Files.isDirectory(directoryPath, new LinkOption[0]), (String)"Given path does not lead to a directory!");
        try (Stream<Path> paths = Files.walk(directoryPath, Boolean.TRUE.equals(applicationSetterParameters.getSearchSubdirectories()) ? Integer.MAX_VALUE : 1, new FileVisitOption[0]);){
            files = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> StringUtils.isBlank((CharSequence)applicationSetterParameters.getFileNameFilter()) || path.getFileName().toString().matches(applicationSetterParameters.getFileNameFilter())).map(Path::toFile).collect(Collectors.toList());
        }
        files.forEach(file -> this.addFileToArchive((File)file, applicationSetterParameters, context));
    }

    private void addFileToArchive(File file, UploadDocumentFromDiskParameters applicationSetterParameters, WorkflowContext context) {
        try (FileInputStream stream = new FileInputStream(file);){
            DocumentDefinition definition = this.buildDocumentDefinition(applicationSetterParameters, context, file, stream);
            AddDocumentResultMeta addDocResultMeta = this.documentService.addDocumentWithMetaResult(definition);
            if (Boolean.TRUE.equals(applicationSetterParameters.getRunDocClassAction())) {
                this.executeClassAction(applicationSetterParameters.getAttachToProcess(), context, addDocResultMeta);
            }
        }
    }

    private File getFile(String pathname) {
        File file = new File(pathname);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("The file does not exist : " + pathname);
        }
        return file;
    }

    private DocumentDefinition buildDocumentDefinition(UploadDocumentFromDiskParameters applicationSetterParameters, WorkflowContext context, File file, InputStream stream) {
        DocumentClassDto docClassDto = this.documentService.getDocumentClassDto(applicationSetterParameters.getDocClassName());
        DocumentDefinition definition = new DocumentDefinition();
        definition.setFileName(file.getName());
        definition.setSaveAsNewVersion(applicationSetterParameters.getSaveAsNewVersion().booleanValue());
        definition.setDocumentClassId(docClassDto.getId());
        definition.setInputStream(stream);
        if (applicationSetterParameters.getAttachToProcess().booleanValue()) {
            definition.setActivityId(context.getActivityId());
            definition.setProcessId(context.getProcessId());
        }
        definition.setDescription(applicationSetterParameters.getDocumentDescription());
        definition.setIndexes(this.documentService.convertIndexes(applicationSetterParameters.getIndexesMapping(), applicationSetterParameters.getDocClassName()));
        definition.setUserName("admin");
        return definition;
    }

    private void executeClassAction(Boolean attachToProcess, WorkflowContext context, AddDocumentResultMeta addDocResultMeta) {
        if (attachToProcess.booleanValue()) {
            this.documentService.executeProcessActions(addDocResultMeta.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, context.getProcessId(), context.getActivityId(), addDocResultMeta.getSavedAsNewVersion());
        } else {
            this.documentService.executeArchiveActions(addDocResultMeta.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE, addDocResultMeta.getSavedAsNewVersion());
        }
    }
}

