/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.utils.converters;

import com.suncode.cuf.common.db.utils.MainDBInfo;
import com.suncode.cuf.common.db.utils.converters.MSSQLConverter;
import com.suncode.cuf.common.db.utils.converters.OracleConverter;
import com.suncode.cuf.common.db.utils.converters.PostgreSQLConverter;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.variable.Variable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBConverter {
    private static final Logger log = LoggerFactory.getLogger(DBConverter.class);

    public static DBConverter getProperDBConverter(MainDBInfo.DBType dbType) {
        switch (dbType) {
            case MSSQL: {
                return new MSSQLConverter();
            }
            case ORACLE: {
                return new OracleConverter();
            }
            case POSTGRESQL: {
                return new PostgreSQLConverter();
            }
        }
        throw new IllegalArgumentException("Unsupported database type.");
    }

    public Object convertValueToProperSingleDBType(Object obj, com.suncode.pwfl.core.type.Type<?> type, Boolean convertEmptyStringToNull) {
        return type == Types.BOOLEAN ? this.convertBoolean(obj) : this.convertToSingleValues(obj, type, convertEmptyStringToNull);
    }

    public Object convertValueToProperDBType(Object obj, com.suncode.pwfl.core.type.Type<?> type, Boolean convertEmptyStringToNull) {
        return type == Types.BOOLEAN ? this.convertBoolean(obj) : this.convertToValues(obj, type, convertEmptyStringToNull);
    }

    public Object[] convertValuesToProperSingleDBTypes(Object[] obj, com.suncode.pwfl.core.type.Type<?>[] types, Boolean convertEmptyStringToNull) {
        Object[] result = new Object[obj.length];
        for (int i = 0; i < result.length; ++i) {
            if (obj[i] == null) {
                throw new IllegalArgumentException("DBValidator fail: Query parameter cannot be null! Please use 'is null' or 'is not null' instead.");
            }
            result[i] = this.convertValueToProperSingleDBType(obj[i], types[i], convertEmptyStringToNull);
        }
        return result;
    }

    public Object[] convertValuesToProperDBTypes(Object[] obj, com.suncode.pwfl.core.type.Type<?>[] types, Boolean convertEmptyStringToNull) {
        Object[] result = new Object[obj.length];
        for (int i = 0; i < result.length; ++i) {
            if (obj[i] == null) {
                throw new IllegalArgumentException("DBValidator fail: Query parameter cannot be null! Please use 'is null' or 'is not null' instead.");
            }
            result[i] = this.convertValueToProperDBType(obj[i], types[i], convertEmptyStringToNull);
        }
        return result;
    }

    protected Object convertToValues(Object obj, com.suncode.pwfl.core.type.Type<?> type, Boolean convertEmptyStringToNull) {
        if (obj == null) {
            return null;
        }
        if (type == Types.INTEGER || type == Types.FLOAT || type == Types.BOOLEAN || type == Types.DATE || type == Types.DATETIME || type == Types.STRING) {
            return this.convertToSingleValues(obj, type, convertEmptyStringToNull);
        }
        if (obj.getClass().isArray()) {
            Object[] values = (Object[])obj;
            return Arrays.stream(values).map(value -> this.convertToSingleValues(value, type, convertEmptyStringToNull)).toArray();
        }
        throw new IllegalArgumentException("Type is " + type.name() + " and value has different type! Value: " + obj);
    }

    protected Object convertToSingleValues(Object obj, com.suncode.pwfl.core.type.Type<?> type, Boolean convertEmptyStringToNull) {
        if (obj == null) {
            return null;
        }
        if (convertEmptyStringToNull.booleanValue() && obj instanceof String && StringUtils.isBlank((CharSequence)((String)obj))) {
            return null;
        }
        if ((type == Types.INTEGER || type == Types.INTEGER_ARRAY) && obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        if (type == Types.FLOAT || type == Types.FLOAT_ARRAY) {
            if (obj instanceof String) {
                return Double.valueOf((String)obj);
            }
        } else if (type == Types.DATE || type == Types.DATE_ARRAY) {
            if (obj instanceof String) {
                LocalDate ld = LocalDate.parse((String)((String)obj), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
                return new Date(ld.toDateTimeAtStartOfDay().getMillis());
            }
            if (obj instanceof LocalDate) {
                return new Date(((LocalDate)obj).toDateTimeAtStartOfDay().getMillis());
            }
        } else if (type == Types.DATETIME || type == Types.DATETIME_ARRAY) {
            if (obj instanceof String) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                try {
                    java.util.Date parsedDate = dateFormat.parse((String)obj);
                    Timestamp timestamp = new Timestamp(parsedDate.getTime());
                    return timestamp;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Given datetime is not formatted correctly!");
                }
            }
            if (obj instanceof LocalDateTime) {
                return new Timestamp(((LocalDateTime)obj).toDateTime().getMillis());
            }
        }
        return obj;
    }

    protected abstract Object convertBoolean(Object var1);

    public Object[] getValidDBValuesFromVariables(Variable[] variablesParams, int arrayIndex, Boolean convertEmptyStringToNull) {
        Object[] params = new Object[variablesParams.length];
        try {
            for (int j = 0; j < variablesParams.length; ++j) {
                params[j] = variablesParams[j].getValue() == null ? null : (variablesParams[j].isArray() ? this.convertValueToProperSingleDBType(((Object[])variablesParams[j].getValue())[arrayIndex], variablesParams[j].getType(), convertEmptyStringToNull) : this.convertValueToProperSingleDBType(variablesParams[j].getValue(), variablesParams[j].getType(), convertEmptyStringToNull));
                log.debug("Query parameter added: " + params[j]);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Variable params have different sizes! All array type values should be at least: " + arrayIndex);
        }
        return params;
    }

    public Type convertToHibernateType(com.suncode.pwfl.core.type.Type<?> type) {
        if (type == Types.STRING || type == Types.STRING_ARRAY) {
            return StringType.INSTANCE;
        }
        if (type == Types.INTEGER || type == Types.INTEGER_ARRAY) {
            return LongType.INSTANCE;
        }
        if (type == Types.FLOAT || type == Types.FLOAT_ARRAY) {
            return DoubleType.INSTANCE;
        }
        if (type == Types.DATE || type == Types.DATE_ARRAY) {
            return DateType.INSTANCE;
        }
        if (type == Types.DATETIME || type == Types.DATETIME_ARRAY) {
            return TimestampType.INSTANCE;
        }
        if (type == Types.BOOLEAN || type == Types.BOOLEAN_ARRAY) {
            return this.getBooleanHibernateType();
        }
        throw new IllegalArgumentException("Unrecognized type: " + type);
    }

    protected abstract Type getBooleanHibernateType();

    public Type[] convertToHibernateTypes(com.suncode.pwfl.core.type.Type<?>[] allParametersTypes) {
        Type[] types = new Type[allParametersTypes.length];
        for (int i = 0; i < allParametersTypes.length; ++i) {
            types[i] = this.convertToHibernateType(allParametersTypes[i]);
        }
        return types;
    }
}

