/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.utils.builders;

import com.suncode.cuf.common.db.utils.builders.IndexFiltersBuilder;
import com.suncode.cuf.common.general.VariableDto;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.workflow.process.search.SimpleIndexFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleIndexFiltersBuilder
extends IndexFiltersBuilder {
    private static final Logger log = LoggerFactory.getLogger(OracleIndexFiltersBuilder.class);

    @Override
    public void addEqualFilter(String id, Object value, Type<?> type) {
        if (value == null) {
            this.filters.add(new SimpleIndexFilter(id, (Object)"", FilterOperator.ISNULL));
        } else {
            this.filters.add(new SimpleIndexFilter(id, value, FilterOperator.EQ));
        }
    }

    @Override
    public void addNotEqualFilter(String id, Object value, Type<?> type) {
        if (value == null) {
            this.filters.add(new SimpleIndexFilter(id, null, FilterOperator.NOTNULL));
        } else {
            this.filters.add(new SimpleIndexFilter(id, value, FilterOperator.NOTEQ));
        }
    }

    @Override
    public void addVariablesFilters(VariableDto[] variables, boolean isPositiveFilter, boolean caseSensitive) {
        for (VariableDto variable : variables) {
            log.debug("Warto\u015b\u0107 sprawdzana: " + variable.getValue());
            if (variable.getPmidxValue() == null || variable.getType() == Types.STRING && variable.getPmidxValue().equals("")) {
                this.addNullFilter(variable.getId(), isPositiveFilter);
                continue;
            }
            if (variable.getType() == Types.STRING && !caseSensitive) {
                this.addCaseInsensitiveFilter(variable.getId(), variable.getPmidxValue(), isPositiveFilter);
                continue;
            }
            log.debug("Dodaje zwykly filtr");
            if (isPositiveFilter) {
                this.addEqualFilter(variable.getId(), variable.getPmidxValue(), variable.getType());
                continue;
            }
            this.addNotEqualFilter(variable.getId(), variable.getPmidxValue(), variable.getType());
        }
    }
}

