/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.duals;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.db.application.utils.VariablesConverter;
import com.suncode.cuf.common.db.duals.dto.ConstArrayDto;
import com.suncode.cuf.common.db.services.DBService;
import com.suncode.cuf.common.db.utils.MainDBInfo;
import com.suncode.cuf.common.db.utils.converters.DBConverter;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.handlers.ApplicationCommentHandler;
import com.suncode.cuf.common.utils.handlers.ErrorHandlersExecution;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;

@VariableSetter
@Application
public class SaveProcessDataInCustomTables {
    @Autowired
    DBService dbService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("custom-table-data-saver")).name("dual-app-set.database.save_custom.name")).description("dual-app-set.database.save_custom.desc")).category(new Category[]{Categories.DATABASE})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}form-data-to-database-saver-application")).icon((Icon)SilkIconPack.DATABASE)).parameter().id("database").name("dual-app-set.database.save_custom.db.name").description("dual-app-set.database.save_custom.db.desc").type((Type)Types.STRING).create()).parameter().id("formTable").name("dual-app-set.database.save_custom.form_table.name").description("dual-app-set.database.save_custom.form_table.desc").type((Type)Types.STRING).optional().create()).parameter().id("formVariables").name("dual-app-set.database.save_custom.form_vars.name").description("dual-app-set.database.save_custom.form_vars.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("constants").name("dual-app-set.database.save_custom.constants.name").description("dual-app-set.database.save_custom.constants.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("constantsTypes").name("dual-app-set.database.save_custom.constants_types.name").description("dual-app-set.database.save_custom.constants_types.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("formColIds").name("dual-app-set.database.save_custom.form_colids.name").description("dual-app-set.database.save_custom.form_colids.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("keyCols").name("dual-app-set.database.save_custom.key_columns.name").description("dual-app-set.database.save_custom.key_columns.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("commentError").name("dual-app-set.database.save_custom.comment_error.name").description("dual-app-set.database.save_custom.comment_error.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("errorMsg").name("dual-app-set.database.save_custom.error-msg.name").description("dual-app-set.database.save_custom.error-msg.desc").type((Type)Types.STRING).optional().create()).parameter().id("constantsColumnsIds").name("dual-app-set.database.save_custom.form_colids.name").description("dual-app-set.database.save_custom.form_colids.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("dbSchema").name("dual-app-set.database.save_custom.db_schema.name").description("dual-app-set.database.save_custom.db_schema.desc").type((Type)Types.STRING).optional().create()).parameter().id("differentColumnLength").name("dual-app-set.database.save_custom.different_column_length.name").description("dual-app-set.database.save_custom.different_column_length.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("convertEmptyStringToNull").name("dual-app-set.database.save_custom.convert_empty_string_to_null.name").description("dual-app-set.database.save_custom.convert_empty_string_to_null..desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("arrayColumnsIds").name("dual-app-set.database.save_custom.form_colids.name").description("dual-app-set.database.save_custom.form_colids.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("functionArray").name("dual-app-set.database.save_custom.function_array.name").description("dual-app-set.database.save_custom.function_array.desc").type((Type)Types.FUNCTION_ARRAY).optional().create();
    }

    public void execute(WorkflowContext context, @Param String database, @Param String formTable, @Param Variable[] formVariables, @Param String[] constants, @Param String[] constantsTypes, @Param String[] formColIds, @Param String[] keyCols, @Param Boolean commentError, @Param String errorMsg, @Param String[] constantsColumnsIds, @Param String dbSchema, Translator translator, @Param Boolean differentColumnLength, @Param Boolean convertEmptyStringToNull, @PairedParam(key="arrayColumnsIds", value="functionArray") Map<String, FunctionCall> constantArray) throws Exception {
        this.run(context, database, dbSchema, formTable, formVariables, constants, constantsTypes, formColIds, keyCols, commentError, errorMsg, constantsColumnsIds, translator, differentColumnLength, convertEmptyStringToNull, constantArray);
    }

    public void set(WorkflowContext context, @Param String database, @Param String formTable, @Param Variable[] formVariables, @Param String[] constants, @Param String[] constantsTypes, @Param String[] formColIds, @Param String[] keyCols, @Param Boolean commentError, @Param String errorMsg, @Param String[] constantsColumnsIds, @Param String dbSchema, Translator translator, @Param Boolean differentColumnLength, @Param Boolean convertEmptyStringToNull, @PairedParam(key="arrayColumnsIds", value="functionArray") Map<String, FunctionCall> constantArray) throws Exception {
        this.run(context, database, dbSchema, formTable, formVariables, constants, constantsTypes, formColIds, keyCols, commentError, errorMsg, constantsColumnsIds, translator, differentColumnLength, convertEmptyStringToNull, constantArray);
    }

    private void run(WorkflowContext context, String database, String dbSchema, String formTable, Variable[] formVariables, String[] constants, String[] constantsTypes, String[] formColIds, String[] keyCols, Boolean commentError, String errorMsg, String[] constantsColumnsIds, Translator translator, Boolean differentColumnLength, Boolean convertEmptyStringToNull, Map<String, FunctionCall> constantArray) throws Exception {
        try {
            MainDBInfo.DBType dbType = this.dbService.getDBType(database);
            DBConverter dbConverter = DBConverter.getProperDBConverter(dbType);
            Type<?>[] constantTypes = DataConverter.convertStringsToTypes(constantsTypes);
            Object[] constantColumns = constants == null || constantsTypes == null ? new Object[]{} : dbConverter.convertValuesToProperSingleDBTypes(constants, constantTypes, convertEmptyStringToNull);
            String[] colIdsForVariables = formColIds.length > formVariables.length ? Arrays.copyOfRange(formColIds, 0, formColIds.length - constantColumns.length) : formColIds;
            String[] colIdsForConstants = this.getConstatsColumnsIds(formColIds, formVariables, constantColumns, constantsColumnsIds);
            List<ConstArrayDto> constArraysList = this.buildConstArrayValues(constantArray);
            List<Map<String, Object>> data = VariablesConverter.convertVariablesToMapList(formVariables, colIdsForVariables, dbConverter, differentColumnLength, convertEmptyStringToNull, constArraysList);
            DataConverter.addConstantColumnsToMapList(data, constantColumns, colIdsForConstants);
            if (ArrayUtils.isEmpty((Object[])keyCols)) {
                this.dbService.insertData(database, dbSchema, formTable, data);
            } else {
                this.dbService.synchronizeData(database, dbSchema, formTable, data, keyCols);
            }
        }
        catch (Exception e) {
            if (!commentError.booleanValue()) {
                throw e;
            }
            String errorMessage = this.buildErrorMessage(ErrorHandlersExecution.rootMessage(e), translator);
            ApplicationCommentHandler handler = new ApplicationCommentHandler(this.commentService, context.getProcessId(), context.getActivityId(), errorMessage);
            ErrorHandlersExecution handlerExecution = new ErrorHandlersExecution(e, handler);
            handlerExecution.handle();
        }
    }

    private List<ConstArrayDto> buildConstArrayValues(Map<String, FunctionCall> constantArray) {
        return constantArray.entrySet().stream().map(entry -> {
            FunctionCall function = (FunctionCall)entry.getValue();
            return ConstArrayDto.builder().columsId((String)entry.getKey()).value((Object[])function.call()).type(function.getReturnType()).build();
        }).collect(Collectors.toList());
    }

    private String[] getConstatsColumnsIds(String[] formColIds, Variable[] formVariables, Object[] constantColumns, String[] constantsColumnsIds) {
        if (formColIds.length > formVariables.length || constantsColumnsIds == null) {
            return Arrays.copyOfRange(formColIds, formColIds.length - constantColumns.length, formColIds.length);
        }
        return constantsColumnsIds;
    }

    private String buildErrorMessage(String message, Translator translator) {
        StringBuilder sb = new StringBuilder();
        sb.append(translator.getMessage("dual-app-set.database.save_custom.error")).append(": ").append(message);
        return sb.toString();
    }
}

