/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.application.utils;

import com.suncode.cuf.common.db.duals.dto.ConstArrayDto;
import com.suncode.cuf.common.db.utils.converters.DBConverter;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.workflow.variable.Variable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class VariablesConverter {
    private static final Logger log = LoggerFactory.getLogger(VariablesConverter.class);

    public static List<Map<String, Object>> convertVariablesToMapList(Variable[] variables, String[] colIds, DBConverter dbConverter, Boolean differentColumnLength, Boolean convertEmptyStringToNull, List<ConstArrayDto> constArrayValues) {
        ArrayList<Map<String, Object>> dbData = new ArrayList<Map<String, Object>>();
        log.info("Taking data form variables:");
        VariablesConverter.compareLengths(variables.length, colIds.length);
        if (!VariablesConverter.doesContainTabularVariables(variables) && constArrayValues.isEmpty()) {
            log.info("There were no tabular variables given in arguments.");
            VariablesConverter.addOrdinaryVariablesData(dbData, variables, colIds, dbConverter, convertEmptyStringToNull);
        } else {
            log.info("There were tabular variables given in arguments.");
            VariablesConverter.addTabularVariablesData(dbData, variables, colIds, dbConverter, differentColumnLength, convertEmptyStringToNull, constArrayValues);
        }
        return dbData;
    }

    private static void addOrdinaryVariablesData(List<Map<String, Object>> dbData, Variable[] variables, String[] colIds, DBConverter dbConverter, Boolean convertEmptyStringToNull) {
        HashMap<String, Object> ordinaryVariablesRow = new HashMap<String, Object>();
        for (int i = 0; i < variables.length; ++i) {
            log.info("Getting value from variable with id: " + variables[i].getId());
            Object value = dbConverter.convertValueToProperSingleDBType(variables[i].getValue(), variables[i].getType(), convertEmptyStringToNull);
            log.info("Value: " + value);
            ordinaryVariablesRow.put(colIds[i], value);
        }
        dbData.add(ordinaryVariablesRow);
    }

    private static void addTabularVariablesData(List<Map<String, Object>> dbData, Variable[] variables, String[] colIds, DBConverter dbConverter, Boolean differentColumnLength, Boolean convertEmptyStringToNull, List<ConstArrayDto> constArrayValues) {
        int maxDynamicTableLength = VariablesConverter.determineDynamicTableLength(variables, differentColumnLength, constArrayValues);
        VariablesConverter.createEmptyRows(maxDynamicTableLength, dbData);
        if (!differentColumnLength.booleanValue()) {
            for (int i = 0; i < variables.length; ++i) {
                log.info("Getting value from variable with id: " + variables[i].getId());
                for (int j = 0; j < dbData.size(); ++j) {
                    VariablesConverter.fillRowsWithData(dbData, variables, i, j, colIds, dbConverter, convertEmptyStringToNull);
                }
            }
            VariablesConverter.fillRowsWtichConstArrayDAta(dbData, dbConverter, convertEmptyStringToNull, constArrayValues);
        } else {
            Variable[] variablesWithNull = VariablesConverter.fillEmptyRowsWithNull(dbData, variables);
            for (int i = 0; i < variables.length; ++i) {
                log.info("Getting value from variable with id: " + variables[i].getId());
                for (int j = 0; j < dbData.size(); ++j) {
                    VariablesConverter.fillRowsWithData(dbData, variablesWithNull, i, j, colIds, dbConverter, convertEmptyStringToNull);
                }
            }
            VariablesConverter.fillEmptyRowsWithNull(dbData, constArrayValues);
            VariablesConverter.fillRowsWtichConstArrayDAta(dbData, dbConverter, convertEmptyStringToNull, constArrayValues);
        }
    }

    private static void fillRowsWtichConstArrayDAta(List<Map<String, Object>> dbData, DBConverter dbConverter, Boolean convertEmptyStringToNull, List<ConstArrayDto> constArrayValues) {
        for (ConstArrayDto valuesDto : constArrayValues) {
            Object[] values = valuesDto.getValue();
            for (int verticalIndex = 0; verticalIndex < dbData.size(); ++verticalIndex) {
                Map<String, Object> row = dbData.get(verticalIndex);
                Object value = dbConverter.convertValueToProperSingleDBType(values[verticalIndex], DataConverter.getSingleType(valuesDto.getType()), convertEmptyStringToNull);
                log.info("Getting row value from tabular variable: " + value);
                row.put(valuesDto.getColumsId(), value);
            }
        }
    }

    private static void fillEmptyRowsWithNull(List<Map<String, Object>> dbData, List<ConstArrayDto> constArrayValues) {
        for (ConstArrayDto valuesDto : constArrayValues) {
            Object[] previousValues = valuesDto.getValue();
            int originalColumnSize = previousValues.length;
            Class<?> typeObject = previousValues.getClass().getComponentType();
            Object[] newValues = (Object[])Array.newInstance(typeObject, dbData.size());
            for (int j = 0; j < dbData.size(); ++j) {
                newValues[j] = j < originalColumnSize ? previousValues[j] : null;
            }
            valuesDto.setValue(newValues);
        }
    }

    private static void fillRowsWithData(List<Map<String, Object>> dbData, Variable[] variables, int horizontalIndex, int verticalIndex, String[] colIds, DBConverter dbConverter, Boolean convertEmptyStringToNull) {
        Map<String, Object> row = dbData.get(verticalIndex);
        if (!variables[horizontalIndex].isArray()) {
            log.info("Variable type: single");
            Object value = dbConverter.convertValueToProperSingleDBType(variables[horizontalIndex].getValue(), variables[horizontalIndex].getType(), convertEmptyStringToNull);
            log.info("Getting value from single variable: " + value);
            row.put(colIds[horizontalIndex], value);
        } else {
            log.info("Variable type: tabular");
            Object[] values = (Object[])variables[horizontalIndex].getValue();
            Object value = dbConverter.convertValueToProperSingleDBType(values[verticalIndex], DataConverter.getSingleType(variables[horizontalIndex].getType()), convertEmptyStringToNull);
            log.info("Getting row value from tabular variable: " + value);
            row.put(colIds[horizontalIndex], value);
        }
    }

    private static Variable[] fillEmptyRowsWithNull(List<Map<String, Object>> dbData, Variable[] variables) {
        Variable[] variablesWithNull = new Variable[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            int originalColumnSize = 1;
            if (variables[i].isArray()) {
                Object[] previousValues = (Object[])variables[i].getValue();
                originalColumnSize = VariablesConverter.getColumnSize(variables[i]);
                Class<?> typeObject = previousValues.getClass().getComponentType();
                Object[] newValues = (Object[])Array.newInstance(typeObject, dbData.size());
                variablesWithNull[i] = variables[i];
                for (int j = 0; j < dbData.size(); ++j) {
                    newValues[j] = j < originalColumnSize ? previousValues[j] : null;
                }
                variablesWithNull[i].setValue((Object)newValues);
                continue;
            }
            variablesWithNull[i] = variables[i];
        }
        return variablesWithNull;
    }

    private static int getColumnSize(Variable variable) {
        int columnSize = 0;
        Object[] values = (Object[])variable.getValue();
        for (int i = 0; i < values.length; ++i) {
            ++columnSize;
        }
        return columnSize;
    }

    private static void compareLengths(int variablesLength, int colIdsLength) {
        Assert.isTrue((colIdsLength == variablesLength ? 1 : 0) != 0, (String)"The number of variables is not the same as the number of column ids!");
    }

    public static int determineDynamicTableLength(Variable[] variables, Boolean differentColumnLength, List<ConstArrayDto> constArrayValues) {
        int maxDynamicTableLength = 0;
        int dynamicTableLength = 0;
        int lastColumnLength = 0;
        for (Variable variable : variables) {
            if (variable.isArray()) {
                Object[] values = (Object[])variable.getValue();
                dynamicTableLength = values.length;
                if (lastColumnLength != 0 && !differentColumnLength.booleanValue() && dynamicTableLength != lastColumnLength) {
                    throw new IllegalStateException("Saved columns have different sizes! Column with id: " + variable.getId() + " has length of " + values.length + ", but previous column has " + lastColumnLength + " values.");
                }
                if (dynamicTableLength > maxDynamicTableLength) {
                    maxDynamicTableLength = dynamicTableLength;
                }
                lastColumnLength = dynamicTableLength;
                continue;
            }
            dynamicTableLength = 1;
            maxDynamicTableLength = dynamicTableLength > maxDynamicTableLength ? dynamicTableLength : maxDynamicTableLength;
        }
        for (ConstArrayDto valuesDto : constArrayValues) {
            Object[] arrValue = valuesDto.getValue();
            dynamicTableLength = arrValue.length;
            if (lastColumnLength != 0 && !differentColumnLength.booleanValue() && dynamicTableLength != lastColumnLength) {
                throw new IllegalStateException("Saved columns have different sizes! Column with id: " + valuesDto.getColumsId() + " has length of " + arrValue.length + ", but previous column has " + lastColumnLength + " values.");
            }
            if (dynamicTableLength > maxDynamicTableLength) {
                maxDynamicTableLength = dynamicTableLength;
            }
            lastColumnLength = dynamicTableLength;
        }
        return maxDynamicTableLength;
    }

    private static boolean doesContainTabularVariables(Variable[] variables) {
        for (Variable variable : variables) {
            if (!variable.isArray()) continue;
            return true;
        }
        return false;
    }

    private static void createEmptyRows(int maxDynamicTableLength, List<Map<String, Object>> dbData) {
        for (int i = 0; i < maxDynamicTableLength; ++i) {
            HashMap row = new HashMap();
            dbData.add(row);
        }
    }
}

