/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.datasource.servlets;

import com.suncode.cuf.common.datasource.servlets.DataFromDatasourceDefinition;
import com.suncode.cuf.common.datasource.servlets.DatasourceParamsRequestDto;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SimpleFilter;
import com.suncode.pwfl.search.Sorter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datasources"})
public class DatasourceController {
    @Autowired
    private DataSourceService datasourceService;

    @ResponseBody
    @RequestMapping(value={"execute"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public List<Map<String, Object>> executeDatasource(@RequestBody DatasourceParamsRequestDto request) {
        CountedResult<Map<String, Object>> countedData = this.getCountedResult(request.getDatasourceId(), request.getDatasourceInputParametersId(), request.getDatasourceInputParametersValue(), Collections.emptyMap(), null);
        return countedData.getData();
    }

    @ResponseBody
    @RequestMapping(value={"get-data"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CountedResult<Map<String, Object>> getData(@RequestBody DataFromDatasourceDefinition request) {
        Map<String, String> filters = this.getFiltersMap(request.getFilters());
        Pagination pagination = this.getPagination(request);
        return this.getCountedResult(request.getDatasourceId(), request.getDatasourceInputParametersId(), request.getDatasourceInputParametersValue(), filters, pagination);
    }

    private CountedResult<Map<String, Object>> getCountedResult(String datasourceId, String[] datasourceInputParametersId, String[] datasourceInputParametersValue, Map<String, String> filters, Pagination pagination) {
        Assert.isTrue((datasourceInputParametersId.length == datasourceInputParametersValue.length ? 1 : 0) != 0, (String)"Input parameters lists has different sizes!");
        DataSourceInstance datasource = this.datasourceService.getDataSource(datasourceId);
        Assert.notNull((Object)datasource, (String)"Chosen datasource does not exist!");
        Map<String, String> datasourceInputParameters = this.getInputParametersMap(datasource, datasourceInputParametersId, datasourceInputParametersValue);
        return datasource.execute(datasourceInputParameters, filters, pagination);
    }

    private Pagination getPagination(DataFromDatasourceDefinition requestDto) {
        Sorter sorter = requestDto.getSorters().get(0);
        return Pagination.create((Sorter)sorter, (Integer)requestDto.getStart(), (Integer)requestDto.getLimit());
    }

    private Map<String, String> getFiltersMap(List<SimpleFilter> filtersList) {
        return filtersList.stream().collect(Collectors.toMap(SimpleFilter::getProperty, filter -> this.extractValue(filter.getValue())));
    }

    private String extractValue(Object value) {
        String stringValue = String.valueOf(value);
        return stringValue.substring(1, stringValue.length() - 1);
    }

    private Map<String, String> getInputParametersMap(DataSourceInstance datasource, String[] datasourceInputParametersId, String[] datasourceInputParametersValue) {
        return IntStream.range(0, datasourceInputParametersId.length).boxed().filter(i -> datasource.getInputParameters().stream().anyMatch(datasourceInputParameter -> datasourceInputParameter.getId().equals(datasourceInputParametersId[i]))).collect(Collectors.toMap(i -> datasourceInputParametersId[i], i -> datasourceInputParametersValue[i], (key, value) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", key));
        }, LinkedHashMap::new));
    }
}

