/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.activity.functions;

import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.FunctionContext;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;

@Functions
@FunctionsScript(value="/functions/activity-functions.js")
public class ActivityFunctions {
    @Autowired
    private ActivityService activityService;

    @Function
    public String currentActivityName() {
        FunctionContext functionContext = FunctionContext.current();
        return this.activityService.getActivityName(functionContext.getProcessDefId(), functionContext.getActivityDefId());
    }

    @Function(accessibility=Function.FunctionAccessibility.BROWSER)
    public Boolean isHistoryOfActivity() {
        return false;
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public String getActivityState(String processId, String activityId) {
        Activity activity = this.activityService.getActivity(processId, activityId, new String[0]);
        return activity.getState().getStateText();
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public Boolean isActivityState(String processId, String activityId, String[] state) {
        Activity activity = this.activityService.getActivity(processId, activityId, new String[0]);
        return Arrays.asList(state).contains(activity.getState().getStateText());
    }
}

