PWE.integrationComponent.registerFormAction('set-variables', {
	apiVersion: 2,
	buildForm: function(form, options) {
		if (options.destination != "LABEL") {
			var table = form.addTable({
				tableId: "variablesAndvalues"
			});
			table.addField({ id: "variables", notEmpty: true, optional: false });
			table.addField({ id: "values", notEmpty: true, optional: false });
		} else {
			form.addField({ id: "labelValueToSet", optional: false });
		}

		if (options.destination != "BUTTON" && options.destination != "DT_BUTTON") {
			form.addCombobox({
				id: "executeTypes",
				values: [
					{ id: "UPDATING_VARIABLES", display: CUFCommon.t('action.set-variables.execute-type.updating-variables') },
					{ id: "CONDITIONAL_EXECUTE", display: CUFCommon.t('action.set-variables.execute-type.conditional-execute') }
				],
				listeners: {
					change: function(value) {
						var fullValue = form.getValue("executeTypes");
						if (fullValue.indexOf("UPDATING_VARIABLES") > -1) {
							form.show("updatingVariables");
							form.setNotEmpty("updatingVariables", true);
						}
						else {
							form.resetArray("updatingVariables");
							form.hide("updatingVariables");
							form.setNotEmpty("updatingVariables", false);
						}
					}
				},
				notEmpty: false,
				optional: true,
				hidden: true
			});
			form.addCombobox({
				id: "executeType",
				values: [
					{ id: "UPDATING_VARIABLES", display: CUFCommon.t('action.set-variables.execute-type.updating-variables') },
					{ id: "CONDITIONAL_EXECUTE", display: CUFCommon.t('action.set-variables.execute-type.conditional-execute') }
				],
				listeners: {
					change: function(value) {
						if (value.indexOf("UPDATING_VARIABLES") > -1) {
							form.show("updatingVariables");
							form.setNotEmpty("updatingVariables", true);
						}
						else {
							form.resetArray("updatingVariables");
							form.setNotEmpty("updatingVariables", false);
							form.hide("updatingVariables");
						}
					}
				},
				notEmpty: true
			});
			form.addField({
				id: "updatingVariables",
				notEmpty: true
			});

			if (form.getValue("executeType").indexOf("UPDATING_VARIABLES") > -1) {
				form.show("updatingVariables");
				form.setNotEmpty("updatingVariables", true);
			}
			else if (form.getValue("executeType").indexOf("CONDITIONAL_EXECUTE") > -1) {
				form.resetArray("updatingVariables");
				form.setNotEmpty("updatingVariables", false);
				form.hide("updatingVariables");
			}
			else {
				if (form.getValue("executeTypes").indexOf("UPDATING_VARIABLES") > -1) {
					form.setValue("executeType", "UPDATING_VARIABLES");
				}
				else {
					form.setValue("executeType", "CONDITIONAL_EXECUTE");
				}
			}
		}
	}
});