PW.FormActions.create('user-data-action', {
    
    init : function() {
        for (var i = 0; i < this.get("resultVariables").length; i++){
            if (this.get("resultVariables").length == 1 && this.get("resultVariables")[0] == null) break;
            if (!this.get("resultVariables")[i].getType().is("string") && !this.get("resultVariables")[i].getType().is("string[]")){
                Logger.error(CUFCommon.t("action.user-data.wrong-variable-type"));
                Ext4.Msg.show({
                    title: CUFCommon.t("action.wrong-configuration"),
                    msg: CUFCommon.t("action.user-data.wrong-variable-type"),
                    buttons: Ext4.Msg.OK,
                    icon: Ext4.Msg.ERROR,
               });
            }
        }
    
    },
    
    variableInit : function(variable) {
        this.variable = variable;
    },
    
    buttonInit : function(button) {
        this.button = button;
    },
    
    defaultActions: {
        button: function(button){
             this.setData();
         }
     },
    
    enable : function() {
        if (!this.button) {
            this.setData();
        }
        if (this.variable){
            this.variable.on("change", this.setData, this);
        }
    },
    
    disable : function() {
        if (this.variable){
            this.variable.off("change", this.setData, this);
        }
    },

    setData : function() {
        var me = this;
        this.lock = new Suncode.form.plugin.locking.Lock();
        this.lock.pushVariable(this.get("resultVariable"));
        var lock = this.lock;
        lock.lock();
        var request = jQuery.ajax({
            type : "GET",
            data : me.getRequestParams(),
            url : me.getRequestUrl(),
            error :  function(jqXHR, textStatus, errorThrown) {
                Logger.error(errorThrown);
            }, 
            async : true
        })
        .done(function (data){
            if (jQuery.isEmptyObject(data)){
                Logger.error("No data recevied for user: " + me.get("username"));
                return;
            }
            var resultVariables = me.get("dataType") ? [me.get("resultVariable")] : me.get("resultVariables");
            var dataTypes = me.get("dataType") ? [me.get("dataType")] : me.get("dataTypes");
            if (devMode){
        		Logger.debug("Action user-data will now set variables...");
        	}
            for (var i = 0; i < resultVariables.length; i++){
                if (resultVariables[i].getType().isArray){
                    if(data[dataTypes[i]] != ""){
                        resultVariables[i].setValue(data[dataTypes[i]].split(";"));
                    }
                }
                else{
                    resultVariables[i].setValue(data[dataTypes[i]]);
                }
            }
        })
        .fail(function(){
            Logger.error("Request failed.");
        })
        .always(function(){
            lock.unlock();
        });
    },
    
    getRequestParams : function() {
        return {
            username : this.get("username"),
            dataTypes : this.get("dataType") ? [this.get("dataType")] : this.get("dataTypes") 
        }
    },
    
    getRequestUrl : function() {
        return "plugin/com.suncode-cuf-components/user/user-data/";
    }
});