/**
 * Implementation of generate document
 */
PW.FormActions.create('generate-document', {
	
    defaultActions: {
        button: function() {
            this.generateDocument();
        }
    },
    
    generateDocument: function(){
    	var fileId = this.getFileId(this.get("documentTemplateClassName"));
    	
        var cfg = {
            format: this.get("format"),
            show: this.get("show"),
            message: this.get("message"),
            documentClass: this.get("documentClass"),
            template: this.get("template"),
            attachToProcess: this.get("attachToProcess"),
            newVersion: this.get("newVersion"),
            mappings: this.getMappings(),
            documentName: this.get("documentName"),
            previewOnly: this.get("fileDestination") === "preview",
            fileId: fileId,
			successfulFileGenerationMessage: this.get("successfulFileGenerationMessage"),
			messageContent: this.get("messageContent"),
			documentOwner: this.get("documentOwner")
		};
        
        if ( cfg.fileId || cfg.template ) {
        	CUF.WordTemplateService.generate(cfg);
        }
        else {
        	Logger.error( CUFCommon.t("action.generate-document.no-template.error") );
        }
    },
    
    getMappings: function(){
    	var mappings = {};
    	var mapIds = this.get("mappingsIds");
    	var mapValues = this.get("mappingsValues");
    	if (mapIds && mapValues ){
    		PW.each(mapIds, function(id, index){
    			mappings[id] = mapValues[index];
    		})
    	}
    	return mappings;
    },
    
    getFileId: function( docClassName ){
    	var fileId = "";
    	if ( docClassName ) {
    		jQuery.ajax({
    			type : "GET",
    			url : "plugin/com.suncode-cuf-components/docs/documentFromProcess/" + docClassName,
    			data:{
    				processId: processId
    			},
    			error :  function(jqXHR, textStatus, errorThrown) {
    				Logger.error(errorThrown);
    			}, 
    			async : false
    		})
    		.done(function (data){
    			if ( data.total == 0 ) {
    				Logger.error( CUFCommon.t("action.generate-document.no-template.error") );
    				MessageService.showFailure(CUFCommon.t("action.generate-document.no-template.error"));
    			}
    			else if ( data.total > 1 ) {
    				Logger.error( CUFCommon.t("action.generate-document.too-many-templates.error") );
    				MessageService.showFailure(CUFCommon.t("action.generate-document.too-many-templates.error"));   
    			}
    			else {
    				fileId = data.data[0].fileId;
    			}
    		})
    		.fail(function(){
    			Logger.error("Request failed.");
    		})
    		.always(function(){
    		
    		});
    	}
    	return fileId;
    }
});

