/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.tablestore.functions;

import com.suncode.cuf.common.tablestore.TableStore;
import com.suncode.cuf.common.tablestore.TableStoreDataType;
import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.workflow.form.function.annotation.FunctionsFormScript;
import com.suncode.pwfl.workflow.variable.Variable;
import org.joda.time.LocalDate;

@Functions
@FunctionsScript(value="/functions/tablestore-functions.js")
@FunctionsFormScript(value="/scripts/dynamic-pwe/tablestore-functions-form.js")
public class TableStoreFunctions {
    @Function(value="TableStore.create")
    public String create(Variable[] variables) {
        return new TableStore(variables).toJson();
    }

    @Function(value="TableStore.create", accessibility=Function.FunctionAccessibility.BROWSER)
    public String create(String tableId) {
        return null;
    }

    @Function(value="TableStore.length")
    public int length(String tableStoreStr) {
        return TableStore.fromJson(tableStoreStr).getLength();
    }

    @Function(value="TableStore.keys")
    public String[] keys(String tableStoreStr) {
        return TableStore.fromJson(tableStoreStr).getKeys();
    }

    @Function(value="TableStore.joinField")
    public String joinField(String tableStoreStr, String fieldId, String separator) {
        return TableStore.fromJson(tableStoreStr).joinField(fieldId, separator);
    }

    @Function(value="TableStore.addRecord")
    public String addRecord(String tableStoreStr, String[] fieldIds, String[] values) {
        TableStore tableStore = TableStore.fromJson(tableStoreStr);
        tableStore.addRecord(fieldIds, values);
        return tableStore.toJson();
    }

    @Function(value="TableStore.addRecords")
    public String addRecords(String tableStoreStr, String tableStoreToAddStr) {
        TableStore tableStore = TableStore.fromJson(tableStoreStr);
        tableStore.addRecords(TableStore.fromJson(tableStoreToAddStr));
        return tableStore.toJson();
    }

    @Function(value="TableStore.filter")
    public String filter(String tableStoreStr, String logicalOperator, String[] fieldIds, String[] operators, String[] values) {
        TableStore tableStore = TableStore.fromJson(tableStoreStr);
        tableStore.filter(logicalOperator, fieldIds, operators, values);
        return tableStore.toJson();
    }

    @Function(value="TableStore.getItem")
    public String getStringItem(String tableStoreStr, String fieldId, int elementNr) {
        return TableStore.fromJson(tableStoreStr).getItem(fieldId, elementNr).toString();
    }

    @Function(value="TableStore.getItem")
    public Long getLongItem(String tableStoreStr, String fieldId, int elementNr) {
        Object item = TableStore.fromJson(tableStoreStr).getItem(fieldId, elementNr);
        if (item instanceof Double) {
            return ((Double)TableStore.fromJson(tableStoreStr).getItem(fieldId, elementNr)).longValue();
        }
        if (item instanceof Long) {
            return (Long)TableStore.fromJson(tableStoreStr).getItem(fieldId, elementNr);
        }
        throw new IllegalArgumentException("Item " + fieldId + "#" + elementNr + " has wrong type!");
    }

    @Function(value="TableStore.getItem")
    public Double getDoubleItem(String tableStoreStr, String fieldId, int elementNr) {
        return (Double)TableStore.fromJson(tableStoreStr).getItem(fieldId, elementNr);
    }

    @Function(value="TableStore.getItem")
    public LocalDate getDateItem(String tableStoreStr, String fieldId, int elementNr) {
        return LocalDate.parse((String)TableStore.fromJson(tableStoreStr).getItem(fieldId, elementNr).toString());
    }

    @Function(value="TableStore.setItems")
    public String setItems(String tableStoreStr, int elementNr, String[] fieldIds, String[] values) {
        TableStore tableStore = TableStore.fromJson(tableStoreStr);
        tableStore.setItems(elementNr, fieldIds, values);
        return tableStore.toJson();
    }

    @Function(value="TableStore.addColumn")
    public String addColumn(String tableStoreStr, String columnId, String dataType) {
        TableStore tableStore = TableStore.fromJson(tableStoreStr);
        tableStore.addColumn(columnId, TableStoreDataType.valueOf(dataType.toUpperCase()));
        return tableStore.toJson();
    }

    @Function(value="TableStore.sort")
    public String sort(String tableStoreStr, String columnId, String sortDirection) {
        TableStore tableStore = TableStore.fromJson(tableStoreStr);
        tableStore.sort(columnId, sortDirection);
        return tableStore.toJson();
    }

    @Function(value="TableStore.deleteRecord")
    public String deleteRecord(String tableStoreStr, int elementNumber) {
        TableStore tableStore = TableStore.fromJson(tableStoreStr);
        tableStore.deleteRecord(elementNumber);
        return tableStore.toJson();
    }
}

