/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.libreoffice.services;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.suncode.cuf.common.documents.libreoffice.services.LibreOfficeManager;
import com.suncode.cuf.common.documents.libreoffice.services.LibreOfficeService;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginFramework;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LibreOfficeServiceImpl
implements LibreOfficeService {
    private static final Logger log = LoggerFactory.getLogger(LibreOfficeServiceImpl.class);
    private static final String[] SUPPORTED_MIME_TYPES = new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/msword", "text/csv", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.spreadsheet", "application/rtf", "application/vnd.ms-powerpoint", "application/vnd.ms-excel", "application/vnd.oasis.opendocument.presentation", "text/plain", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};
    private final Tika tika = new Tika();
    @Autowired
    private PluginFramework pluginFramework;

    @Override
    public CompletableFuture<String> convertToPdfAsync(String inputDocumentPath, String outputDocumentPath, String libreOfficePath) {
        AtomicReference connectionHolder = new AtomicReference();
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            LibreOfficeManager.LibreOfficeConnection libreOfficeConnection = new LibreOfficeManager.LibreOfficeConnection(this.resolveExecutablePath(libreOfficePath));
            connectionHolder.set(libreOfficeConnection);
            XComponent xComponent = null;
            try {
                LibreOfficeManager.startLibreOffice(libreOfficeConnection);
                XComponentContext xComponentContext = libreOfficeConnection.getContext();
                XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", xComponentContext));
                String sourceDocumentPath = "file:///" + inputDocumentPath.replace('\\', '/');
                String destinationDocumentPath = outputDocumentPath.replace('\\', '/');
                PropertyValue[] propertyValues = this.createPropertyValue(new String[]{"ReadOnly", "Hidden"}, new Object[]{Boolean.TRUE, Boolean.TRUE});
                xComponent = xComponentLoader.loadComponentFromURL(sourceDocumentPath, "_blank", 0, propertyValues);
                XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
                propertyValues = this.createPropertyValue(new String[]{"Overwrite", "FilterName"}, new Object[]{Boolean.TRUE, "writer_pdf_Export"});
                xStorable.storeToURL("file:///" + destinationDocumentPath, propertyValues);
                String string = outputDocumentPath;
                return string;
            }
            catch (Exception e) {
                log.error("Error converting file: " + inputDocumentPath, (Throwable)e);
                throw new RuntimeException("PDF conversion failed", e);
            }
            finally {
                if (xComponent != null) {
                    xComponent.dispose();
                }
                LibreOfficeManager.stopLibreOffice(libreOfficeConnection);
                connectionHolder.set(null);
            }
        });
        return future.orTimeout(60L, TimeUnit.SECONDS).exceptionally(throwable -> {
            if (throwable instanceof TimeoutException) {
                log.error("LibreOffice conversion timeout after {} seconds for file: {}", (Object)60, (Object)inputDocumentPath);
                if (connectionHolder.get() != null) {
                    log.warn("Force cleaning up LibreOffice connection due to timeout");
                    LibreOfficeManager.stopLibreOffice((LibreOfficeManager.LibreOfficeConnection)connectionHolder.get());
                }
                throw new RuntimeException("PDF conversion timeout", (Throwable)throwable);
            }
            throw new RuntimeException((Throwable)throwable);
        });
    }

    @Override
    public boolean checkFileType(String filename) {
        File file = Paths.get(filename, new String[0]).toFile();
        return Arrays.stream(SUPPORTED_MIME_TYPES).anyMatch(allowedMimeType -> {
            try {
                return this.tika.detect(file).equalsIgnoreCase((String)allowedMimeType);
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkInstallation(String libreOfficePath) {
        if (StringUtils.isBlank((CharSequence)libreOfficePath)) {
            return false;
        }
        LibreOfficeManager.LibreOfficeConnection libreOfficeConnection = new LibreOfficeManager.LibreOfficeConnection(this.resolveExecutablePath(libreOfficePath));
        try {
            LibreOfficeManager.startLibreOffice(libreOfficeConnection);
            XComponentContext xContext = libreOfficeConnection.getContext();
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            boolean bl = xMCF != null;
            return bl;
        }
        catch (Exception e) {
            log.error("LibreOffice installation check error!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            LibreOfficeManager.stopLibreOffice(libreOfficeConnection);
        }
    }

    @Override
    public boolean checkLicence(String pluginKey) {
        Plugin plugin = this.pluginFramework.getPlugin(pluginKey);
        return plugin != null && plugin.hasValidLicense();
    }

    private String resolveExecutablePath(String libreOfficePath) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return Paths.get(libreOfficePath, "soffice.exe").toString();
        }
        return Paths.get(libreOfficePath, "soffice").toString();
    }

    private PropertyValue[] createPropertyValue(String[] names, Object[] values) {
        if (names.length != values.length) {
            return new PropertyValue[0];
        }
        PropertyValue[] propertyValue = new PropertyValue[names.length];
        IntStream.range(0, names.length).forEach(i -> {
            propertyValue[i] = new PropertyValue();
            propertyValue[i].Name = names[i];
            propertyValue[i].Value = values[i];
        });
        return propertyValue;
    }
}

