PWE.integrationComponent.registerValidator( 'verify-documents', {
    apiVersion: 2,
    buildForm: function( form ) {
        form.addCombobox({
            id : "verificationMode",
            values : [{id : "activity", display : CUFCommon.t("verify-documents.activity")},
                      {id : "stage", display : CUFCommon.t("verify-documents.stage")},
                      {id : "process", display : CUFCommon.t("verify-documents.process")}]
        });
        
        var conditionsTable = form.addTable({
            id : "conditionsTable", 
            name: CUFCommon.t("verify-documents.conditionsTable.name"),
            description: CUFCommon.t("verify-documents.conditionsTable.desc")
        });
        CufComp.addComboboxClassList("documentClassName", null, conditionsTable);
        conditionsTable.addCombobox({
            id: "conditionType",
            values: [
                { id: "=", display: "=" },
                { id: "!=", display: "!=" },
                { id: "<", display: "<" },
                { id: ">", display: ">" },
                { id: "<=", display: "<=" },
                { id: ">=", display: ">=" }
            ]
        });
        
        conditionsTable.addField("documentCount");
        conditionsTable.addField("fileNameRegExp");
        
        form.addCombobox({id: "conditionalOperator",
            values: [
                { id: "AND", display: "AND", description: CUFCommon.t("verify-documents.conditionalOperator.param.and.desc") },
                { id: "OR", display: "OR", description: CUFCommon.t("verify-documents.conditionalOperator.param.or.desc") }
            ]
        });
        form.addField("confirmation");
        form.setNotEmpty("documentClassName", true);
        form.setNotEmpty("conditionType", true);
        form.setNotEmpty("documentCount", true);
    }
});
