PWE.integrationComponent.registerApplication('table-store-add-column-dual', {
    apiVersion: 2,
    buildForm: build,
    validateForm: validate
});

PWE.integrationComponent.registerVariablesSetter('table-store-add-column-dual', {
    apiVersion: 2,
    buildForm: build,
    validateForm: validate
});

function build(form) {
    form.addField("tableStoreParam");
    form.addField("columnId");
    form.addCombobox({
        id: 'dataType',
        valueField: 'id',
        values: [
            { id: 'STRING', display: CUFCommon.t('default.string-array'), description: CUFCommon.t('default.string-array')},
            { id: 'INTEGER', display: CUFCommon.t('default.integer-array'), description: CUFCommon.t('default.integer-array')},
            { id: 'FLOAT', display: CUFCommon.t('default.float-array'), description: CUFCommon.t('default.float-array')},
            { id: 'DATE', display: CUFCommon.t('default.date-array'), description: CUFCommon.t('default.date-array')}
        ]
    });
}

function validate(api) {
    if (api.getVariableType('tableStoreParam') !== 'string') {
        api.markError('tableStoreParam');
        api.showErrorMessage(CUFCommon.t('form-valid-string'));
        return false;
    }
    return true;
}
