PWE.integrationComponent.registerFormAction('data-table-from-db-action', {
	apiVersion: 2,
	buildForm: function(form, options) {
		form.addField("datebaseName");
		CufComp.obtainDataBaseAliases("datebaseName", form);
		form.addField("queryKey");
		var queryTable = form.addTable();
		queryTable.addField("queryParameters");
		queryTable.addCombobox({
			id: "queryParametersTypes",
			values: [
				{ id: "string", display: CUFCommon.t("query-param-type.text") },
				{ id: "integer", display: CUFCommon.t("query-param-type.integer") },
				{ id: "float", display: CUFCommon.t("query-param-type.float") },
				{ id: "date", display: CUFCommon.t("query-param-type.date") },
				{ id: "datetime", display: CUFCommon.t("query-param-type.date-time") }
			]
		});
		var columnTable = form.addTable();
		columnTable.addField("columnNames");
		columnTable.addField("columnIndexes");
		columnTable.addField("columnsToSet");
		columnTable.addCombobox({
			id: "columnsTypes",
			values: [
				{ id: "string", display: CUFCommon.t("query-param-type.text") },
				{ id: "integer", display: CUFCommon.t("query-param-type.integer") },
				{ id: "float", display: CUFCommon.t("query-param-type.float") },
				{ id: "date", display: CUFCommon.t("query-param-type.date") }
			]
		});
		columnTable.addField("isHiddenColumn");
		columnTable.addField("wrapText");

		form.addField("pageSize");
		form.addField("overwrite");
		form.addField({
			id: "moving",
			listeners: {
				change: function(value) {
					if (!value) {
						form.hide('multipleRowsSelection');
						form.hide('multiVals');
						form.setNotEmpty("dynamicTableId", false);
						form.hide("dynamicTableId");
					} else {
						form.show('multipleRowsSelection');
						changeVisibility(form, 'multiVals', form.getValue('multipleRowsSelection'));
						form.setNotEmpty("dynamicTableId", true);
						form.show("dynamicTableId");
					}
				}
			}
		});
		form.addField({
			id: "multipleRowsSelection",
			hidden: !form.getValue('moving'),
			listeners: {
				change: function(value) {
					changeVisibility(form, 'multiVals', value);
				}
			}
		});
		addMultipleValuesHandlingMethods(form);
		form.addField("numbered");
		if (options.destination == "VARIABLESET") {
			form.addField("buttonName");
		}

		form.addField("columnContextMenu");
		if (options.destination == "BUTTON") {
			form.addField({
				id:"dynamicTableId",
				hidden: !form.getValue('moving')
			});
		}

		form.addField("saveFormAfterMoving");
		form.addField("executeAutomapping");
		form.addField("windowName");
	}
});

function addMultipleValuesHandlingMethods(form) {
	form.addCombobox({
		id: "multiVals",
		hidden: !form.getValue('multipleRowsSelection'),
		values: [
			{ id: "BLOCK", display: CUFCommon.t("predefined.multivals.block") },
			{ id: "UNIQUE", display: CUFCommon.t("predefined.multivals.unique") },
			{ id: "FIRST", display: CUFCommon.t("predefined.multivals.first") }
		]
	});
};

function changeVisibility(form, id, value) {
	if (value) {
		form.show(id);
	} else {
		form.hide(id);
	}
}
