/**
 * Implementation of ShowAndAttachDocumentsFromArchive
 */
PW.FormActions.create('show-and-attach-document-from-archive', {

    init: function () {
    },

    buttonInit: function (button) {
        this.button = button;
    },

    defaultActions: {
        button: function (button) {
            if (MobileService.isMobile()) {
                MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
                return;
            }

            this.attachDocumentFromArchive();
        }
    },

    enable: function () {
        if (!this.button) {
            if (MobileService.isMobile()) {
                MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
                return;
            }

            this.attachDocumentFromArchive();
        }
    },

    attachDocumentFromArchive: function () {
        let me = this;
        jQuery.ajax({
            type: "GET",
            url: PlusWorkflow.getAbsolutePath("/plugin/com.suncode-cuf-components/docs/docClassFromDocClassName/" + me.get("document-class-id")),
            error: function (jqXHR, textStatus, errorThrown) {
                Logger.error(errorThrown);
            }
        })
            .done(function (data) {
                let cfg = {
                    documentClassId: data.id,
                    sortBy: me.get("sortBy"),
                    sortDirection: me.get("sortDirection"),
                    displayedIndexNames: me.get("displayedIndexes"),
                };
                if (me.get("search-criteria-on")) {
                    let indexesData = me.getIndexesData(data.indexes);
                    let exactSearchSystemParameter = me.getExactSearchSystemParameter();
                    let forceExactSearch = me.get("force-exact-search");
                    cfg.indexes = me.setCriteriaIndexes(indexesData, me.get("indexes-value"), !exactSearchSystemParameter && forceExactSearch);
                }
                CUF.DocumentService.showAddDocumentsFromArchiveExtendedWindow(cfg);
            })
    },

    getIndexesData: function (indexes) {
        let indexesData = this.get("indexes-id");
        for (let i = 0; i < indexesData.length; i++) {
            for (let j = 0; j < indexes.length; j++) {
                if (indexesData[i] === indexes[j].name) {
                    indexesData[i] = {
                        id: String(indexes[j].id),
                        type: indexes[j].type
                    }
                }
            }
        }
        return indexesData;
    },

    setCriteriaIndexes: function (indexesData, indexesValues, forceExactSearch) {
        let indexesMap = {};
        for (let index = 0; index < indexesData.length; index++) {
            if (indexesData[index].id != null && indexesData[index].id !== "" && indexesValues[index] != null) {
                if (forceExactSearch && indexesData[index].type === "string") {
                    indexesMap[indexesData[index].id] = '"' + indexesValues[index] + '"';
                } else {
                    indexesMap[indexesData[index].id] = indexesValues[index];
                }
            }
        }
        return indexesMap;
    },

    getExactSearchSystemParameter: function () {
        let result;
        jQuery.ajax({
            type: "GET",
            url: "plugin/com.suncode-cuf-components/parameters/exactSearch",
            error: function (jqXHR, textStatus, errorThrown) {
                Logger.error(errorThrown);
            },
            async: false
        })
            .done(function (data) {
                result = data;
            })
        return result;
    }
});

