PW.FormActions.create('processdata-from-query-action', {
	init : function() {
		this.database = this.getRaw("database");
		this.queryTable = this.getRaw("queryTable");
		this.messageService = ServiceFactory.getMessageService();
		this.queryName = this.getRaw("queryName");
		this.targetVariables = this.getRaw("targetVariables");
		this.dynamicTableId = this.getRaw("dynamicTableId");
		this.multiVals = this.getRaw("multiVals");
	},

	defaultActions : {
        button: function(button) {
             this.requestData();
        },
		variable : function(variable, newValue, oldValue) {
			this.requestData();
		}
    },

    enable : function() {
        if(this.target.type == 'FORM'){
            this.requestData();
        }
    },

	addToLock : function(variable) {
		this.lock = new Suncode.form.plugin.locking.Lock();
		this.lock.pushVariable(variable);
	},

	processParams : function(params) {
		var processedParams = [];
		for (var i=0; i < params.length; i++) {
		    if (params[i] == null){
		        processedParams.push(params[i]);
			} else if (params[i].startsWith("@")) {
				processedParams.push(this.getPWVariableData(params[i].substring(1)));
			} else {
				processedParams.push(params[i]);
			}
		}
		return processedParams;
	},

	getPWVariableData : function(variableId) {
		var variableInCheck = ServiceFactory.getVariableService().get(variableId);
		return "'" + String(variableInCheck.getValue()) + "' " + variableInCheck.variableType;
	},

	requestData : function() {
		var me = this;
		let processedParameters = this.processParams(this.get("queryParams"));
		PW.each(this.targetVariables.get(), function(targetVariable){
			this.addToLock(targetVariable);
		}, this);
		var lock = this.lock;
		lock.lock();
		FormService.blockAcceptance();

		jQuery.ajax({
			type : "POST",
			contentType: "application/json; charset=utf-8",
			data : JSON.stringify({
				databaseName : me.database.get(),
				queryTable : me.queryTable.get(),
				queryName : me.queryName.get(),
				queryParams : processedParameters
			}),
			url : "plugin/com.suncode-cuf-components/actions/data/get/",
			error :  function(jqXHR, textStatus, errorThrown) {
				Logger.error(errorThrown);
			},
			async : true
		})
		.done(function (data) {
			if (!data[0]) {
				Logger.error("No data has been returned from the database.")
			}
			else if (!me.dynamicTableId.get()) {
				me.setNormalVariables(me.targetVariables.get(), data, me.multiVals.get());
			}
			else {
				me.setVsVariables(me.targetVariables.get(), data);
			}
		})
		.fail(function(jqXHR, textStatus, errorThrown) {
			Logger.error("Request failed.");
			me.messageService.showFailure(errorThrown);
		})
		.always(function() {
			lock.unlock();
			FormService.unblockAcceptance();
		});
	},

	setNormalVariables : function(targetVariables, data, multiVals) {
		var me = this;
		if (devMode){
    		Logger.debug("Action data-from-query will now set variables...");
    	}
		PW.each(targetVariables, function(targetVariable){
			for(var prop in data[0]){
				if(prop.toLowerCase() == targetVariable.getId()) {
					var returnedValue = me.convertObject(data[0][prop], targetVariable.getType());
					if (data.length < 2) {
						targetVariable.setValue(returnedValue);
					}
					else {
						switch (multiVals) {
							case 'UNIQUE':
								if (targetVariable.type.name == "string") {
									handleUniqueValues(targetVariable, data);
								}
								else {
									Logger.error("Cannot add multiple values to a non-array variable which is also of a different type than string!");
								}
								break;
							case 'FIRST':
								targetVariable.setValue(returnedValue);
								break;
							default:
								Logger.error("Cannot add multiple values to a non-array variable with multiple value handling unspecified or set to BLOCK!");
								break;
						}
					}
				}
			}
		}, this);

		function handleUniqueValues(targetVariable, data) {
			var uniqueValues = [];
			for (var i=0; i<data.length; i++) {
				var value = data[i][targetVariable.id];
				if (jQuery.inArray(value, uniqueValues) == -1) {
					uniqueValues.push(value);
				}
			}
			var multiVal = "";
			for (var i=0; i<uniqueValues.length; i++) {
				multiVal += uniqueValues[i] + ";";
			}
			targetVariable.setValue(multiVal.substring(0, multiVal.length - 1));
		};
	},

	setVsVariables : function(targetVariables, data) {
		var me = this;
		var oldValues = {};
		if (devMode){
    		Logger.debug("Action data-from-query will now set variables...");
    	}

		var wayOfAdding = me.get("wayOfAdding");
		if( wayOfAdding == 'UNSET' ) {
		    wayOfAdding = me.get("overwrite") ? 'OVERWRITE_ALL_COLUMNS' : 'ADD';
		}

		if(wayOfAdding == "OVERWRITE_ALL_COLUMNS"){
	    	var table = VariableSetService.getVariableSet(this.get("dynamicTableId"));
	    	table.clear();
		}
		else if (wayOfAdding == "ADD"){
			PW.each(targetVariables, function(targetVariable){
				oldValues[targetVariable.getId()] = targetVariable.getValue();
			}, this);
		}

		PW.each(targetVariables, function(targetVariable){
			for(var prop in data[0]){
				if(prop.toLowerCase() == targetVariable.getId()) {
					var value = me.getArrayValues(data, prop, targetVariable.getType());
					if(wayOfAdding == "OVERWRITE_ALL_COLUMNS" || wayOfAdding == "OVERWRITE_UPDATED_COLUMNS") {
						targetVariable.setValue(value);
					}
					else {
						targetVariable.setValue(oldValues[targetVariable.getId()].concat(value));
					}
				}
			}
		}, this);
		VariableSetService.getVariableSet(this.get("dynamicTableId")).refresh();
	},

	getArrayValues : function(data, id, type){
		var result = [];
		for (var i = 0; i < data.length; i++){
			result.push(this.convertObject(data[i][id], type));
		}
		return result;
	},

	convertObject : function(value, type){
		if (!value){
			return null;
		}
		if (type.is("integer") || type.is("float") || type.is("integer[]") || type.is("float[]")){
			return Number(value);
		}
		else if (type.is("datetime") || type.is("date") || type.is("date[]")){
			return new Date(value);
		}
		else if (type.is("boolean")){
			if (typeof value === 'boolean') {
				return value;
			}
			else if (typeof value === 'string') {
				return (value == 'true');
			}
			return false;
		}
		return value;
	}
});

