/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.functions;

import com.suncode.cuf.common.general.enums.JsonDataType;
import com.suncode.cuf.common.general.service.JsonService;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.StringWriter;
import java.io.Writer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Functions
@FunctionsScript(value="/functions/json-functions.js")
public class JsonFunctions {
    @Autowired
    private JsonService jsonService;

    @Function
    public String toJsonObject(String[] keys, String[] values, String[] types) {
        JSONObject object = new JSONObject();
        StringWriter writer = new StringWriter();
        block10: for (int i = 0; i < keys.length; ++i) {
            JsonDataType jsonDataType = JsonDataType.valueOf(types[i]);
            switch (jsonDataType) {
                case STRING: {
                    this.createStringField(object, keys[i], values[i]);
                    continue block10;
                }
                case INTEGER: {
                    this.createIntegerField(object, keys[i], values[i]);
                    continue block10;
                }
                case FLOAT: {
                    this.createDoubleField(object, keys[i], values[i]);
                    continue block10;
                }
                case BOOLEAN: {
                    this.createBooleanField(object, keys[i], values[i]);
                    continue block10;
                }
                case OBJECT: {
                    this.createObjectField(object, keys[i], values[i]);
                    continue block10;
                }
                case ARRAY: {
                    this.createArrayField(object, keys[i], values[i]);
                }
            }
        }
        object.write((Writer)writer);
        return writer.toString();
    }

    @Function
    public String toJsonArray(String[] values, String type) {
        JSONArray array = new JSONArray();
        StringWriter writer = new StringWriter();
        JsonDataType jsonDataType = JsonDataType.valueOf(type);
        block10: for (int i = 0; i < values.length; ++i) {
            switch (jsonDataType) {
                case STRING: {
                    this.createStringValue(array, values[i]);
                    continue block10;
                }
                case INTEGER: {
                    this.createIntegerValue(array, values[i]);
                    continue block10;
                }
                case FLOAT: {
                    this.createDoubleValue(array, values[i]);
                    continue block10;
                }
                case BOOLEAN: {
                    this.createBooleanValue(array, values[i]);
                    continue block10;
                }
                case OBJECT: {
                    this.createObjectValue(array, values[i]);
                    continue block10;
                }
                case ARRAY: {
                    this.createArrayValue(array, values[i]);
                }
            }
        }
        array.write((Writer)writer);
        return writer.toString();
    }

    @Function
    public String toJsonArrayIterator(FunctionCall function, Long maxTableLength, Variable counter, String type) throws JSONException {
        JSONArray array = new JSONArray();
        StringWriter writer = new StringWriter();
        JsonDataType jsonDataType = JsonDataType.valueOf(type);
        int i = 0;
        while ((long)i < maxTableLength) {
            counter.setValue((Object)i);
            String value = function.call().toString();
            switch (jsonDataType) {
                case STRING: {
                    this.createStringValue(array, value);
                    break;
                }
                case INTEGER: {
                    this.createIntegerValue(array, value);
                    break;
                }
                case FLOAT: {
                    this.createDoubleValue(array, value);
                    break;
                }
                case BOOLEAN: {
                    this.createBooleanValue(array, value);
                    break;
                }
                case OBJECT: {
                    this.createObjectValue(array, value);
                    break;
                }
                case ARRAY: {
                    this.createArrayValue(array, value);
                }
            }
            ++i;
        }
        array.write((Writer)writer);
        return writer.toString();
    }

    @Function(value="JSON.jsonPath")
    public String[] jsonPath(String text, String path) {
        return this.jsonService.readJsonPath(text, path);
    }

    @Function(value="JSON.jsonPath")
    public String[] jsonPath(String text, String path, String childNodeName) {
        return this.jsonService.readJsonPath(text, path, childNodeName);
    }

    private void createStringField(JSONObject object, String key, String value) {
        Assert.hasLength((String)key, (String)("Entry key for value: " + value + " cannot be empty or null"));
        object.put(key, (Object)value);
    }

    private void createIntegerField(JSONObject object, String key, String value) {
        Assert.hasLength((String)key, (String)("Entry key for value: " + value + " cannot be empty or null"));
        int intValue = Integer.parseInt(value);
        object.put(key, intValue);
    }

    private void createDoubleField(JSONObject object, String key, String value) {
        Assert.hasLength((String)key, (String)("Entry key for value: " + value + " cannot be empty or null"));
        double doubleValue = Double.parseDouble(value);
        object.put(key, doubleValue);
    }

    private void createBooleanField(JSONObject object, String key, String value) {
        Assert.hasLength((String)key, (String)("Entry key for value: " + value + " cannot be empty or null"));
        boolean booleanValue = Boolean.parseBoolean(value);
        object.put(key, booleanValue);
    }

    private void createObjectField(JSONObject object, String key, String value) {
        Assert.hasLength((String)key, (String)("Entry key for value: " + value + " cannot be empty or null"));
        JSONObject objectValue = new JSONObject(value);
        object.put(key, (Object)objectValue);
    }

    private void createArrayField(JSONObject object, String key, String value) {
        Assert.hasLength((String)key, (String)("Entry key for value: " + value + " cannot be empty or null"));
        JSONArray arrayValue = new JSONArray(value);
        object.put(key, (Object)arrayValue);
    }

    private void createStringValue(JSONArray array, String value) {
        array.put((Object)value);
    }

    private void createIntegerValue(JSONArray array, String value) {
        int intValue = Integer.parseInt(value);
        array.put(intValue);
    }

    private void createDoubleValue(JSONArray array, String value) {
        double doubleValue = Double.parseDouble(value);
        array.put(doubleValue);
    }

    private void createBooleanValue(JSONArray array, String value) {
        boolean booleanValue = Boolean.parseBoolean(value);
        array.put(booleanValue);
    }

    private void createObjectValue(JSONArray array, String value) {
        JSONObject objectValue = new JSONObject(value);
        array.put((Object)objectValue);
    }

    private void createArrayValue(JSONArray array, String value) {
        JSONArray arrayValue = new JSONArray(value);
        array.put((Object)arrayValue);
    }
}

