/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.services;

import com.suncode.cuf.common.db.DBQueryConfig;
import com.suncode.cuf.common.db.QueryBuilder;
import com.suncode.dbexplorer.database.DatabaseSession;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.SQLQuery;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryService")
public class SQLQueryService {
    private static final Logger log = LoggerFactory.getLogger(SQLQueryService.class);
    private QueryBuilder queryBuilder;

    @Autowired
    public SQLQueryService(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected SQLQuery formMergedQuery(DatabaseSession session, List<DBQueryConfig> queries) {
        String multiQuery = this.queryBuilder.createMultiQuery(session, queries);
        log.debug("Query to be executed: {}", (Object)multiQuery);
        NativeQuery sql = session.hibernateSession().createSQLQuery(multiQuery);
        sql.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        int parameterIndex = 1;
        for (int i = 0; i < queries.size(); ++i) {
            Object[] params = queries.get(i).getQueryParams();
            Object[] types = queries.get(i).getQueryParamsTypes();
            log.debug("Adding parameters: {}", params);
            if (ArrayUtils.isEmpty((Object[])types)) {
                types = new Type[params.length];
            }
            for (int index = 0; index < params.length; ++index) {
                this.addParameterToQuery((SQLQuery)sql, params[index], (Type)types[index], parameterIndex, queries.get(i));
                ++parameterIndex;
            }
        }
        return sql;
    }

    protected SQLQuery formExecuteQuery(DatabaseSession session, DBQueryConfig dbQueryCfg) {
        String query = this.queryBuilder.getQueryFromDB(session, dbQueryCfg);
        SQLQuery sql = this.formQueryWithParameters(query, session, dbQueryCfg);
        return sql;
    }

    protected SQLQuery formReturnQuery(DatabaseSession session, DBQueryConfig dbQueryCfg) {
        String query = this.queryBuilder.getQueryFromDB(session, dbQueryCfg);
        SQLQuery sql = this.formQueryWithParameters(query, session, dbQueryCfg);
        sql.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        sql.setFirstResult(dbQueryCfg.getFirst());
        if (dbQueryCfg.getMax() > 0) {
            sql.setMaxResults(dbQueryCfg.getMax());
        }
        return sql;
    }

    protected SQLQuery formCountQuery(DatabaseSession session, DBQueryConfig dbQueryCfg) throws SQLException {
        String countQuery = this.queryBuilder.getCountQueryFromDB(session, dbQueryCfg);
        SQLQuery sql = this.formQueryWithParameters(countQuery, session, dbQueryCfg);
        sql.addScalar("cnt", (Type)StandardBasicTypes.LONG);
        return sql;
    }

    protected String getQueryFromDB(DatabaseSession session, DBQueryConfig dbQueryCfg) {
        return this.queryBuilder.getQueryFromDB(session, dbQueryCfg);
    }

    private SQLQuery formQueryWithParameters(String query, DatabaseSession session, DBQueryConfig dbQueryCfg) {
        log.debug("Forming query: {}", (Object)query);
        NativeQuery sql = session.hibernateSession().createSQLQuery(query);
        this.addParametersToQuery((SQLQuery)sql, dbQueryCfg);
        return sql;
    }

    private SQLQuery addParametersToQuery(SQLQuery sql, DBQueryConfig dbQueryCfg) {
        Object[] params = dbQueryCfg.getQueryParams();
        Object[] types = dbQueryCfg.getQueryParamsTypes();
        log.debug("Adding parameters: " + Arrays.toString(params));
        if (ArrayUtils.isEmpty((Object[])types)) {
            types = new Type[params.length];
        }
        for (int index = 0; index < params.length; ++index) {
            this.addParameterToQuery(sql, params[index], (Type)types[index], index + 1, dbQueryCfg);
        }
        return sql;
    }

    private void addParameterToQuery(SQLQuery sql, Object value, Type type, int index, DBQueryConfig dbQueryCfg) {
        if (!dbQueryCfg.isChangeQuestionMarksToNamedParameters()) {
            if (type != null) {
                sql.setParameter(index, value, type);
            } else {
                sql.setParameter(index, value);
            }
        } else if (value.getClass().isArray()) {
            for (Object singleValue : (Object[])value) {
                if (singleValue != null) continue;
                throw new IllegalArgumentException("ERROR - Query parameter number " + index + " contains null values!");
            }
            sql.setParameterList("param" + index, (Object[])value);
        } else {
            sql.setParameter("param" + index, value, type);
        }
    }
}

