PWE.integrationComponent.registerFormAction('rename-variables', {
    apiVersion: 2,
    buildForm: function (form, options) {
    	switch (options.destination){
		case "BUTTON":
			form.addField({
				id: "newNameElement",
				name: CUFCommon.t("action.rename-variables.destination-name.button"),
				notEmpty: true
			});
			break;
		case "DT_BUTTON":
			form.addField({
                id: "newNameElement",
                name: CUFCommon.t("action.rename-variables.destination-name.button"),
                notEmpty: true
            });
			if (CUFCommon.isDivanteSystem()) {
				form.addField("newElementDescription");
			}
			break;
		case "LABEL":
			form.addField({
                id: "newNameElement",
                name: CUFCommon.t("action.rename-variables.destination-name.label"),
                notEmpty: true
            });
			break;
		case "VARIABLE":
			form.addField({
                id: "newNameElement",
                name: CUFCommon.t("action.rename-variables.destination-name.variable"),
                notEmpty: true
            });
			if (CUFCommon.isDivanteSystem()) {
				form.addField("newElementDescription");
			}
			break;
		case "VARIABLESET":
			form.addField({
                id: "newNameElement",
                name: CUFCommon.t("action.rename-variables.destination-name.variableSet"),
                notEmpty: true
            });
			break;
		case "FORM":
			var table = form.addTable({
    			tableId: "namesToChangeAndNewNames"
    		});
    		table.addField({ id: "namesToChange", notEmpty: true, optional: false });
	    	table.addField({ id: "newNameForm", notEmpty: true, optional: false });
			if (CUFCommon.isDivanteSystem()) {
				table.addField({ id: "newElementsDescription", optional: true });
			}
			break;
    	}
    }
});
