/**
 * Form of edition variables action
 */

PWE.integrationComponent.registerFormAction( 'edition-variables', {
    apiVersion: 2,
    buildForm: function( form , options ) {
        var destination = options.destination;
        var isVariablesRequired = options.destination != "VARIABLE";
        form.addField({id:"variables", optional: !isVariablesRequired, notEmpty: isVariablesRequired });
        form.hide("variables");
        form.addField("contextCondition");
        form.hide("contextCondition");
        var enableComboboxOptions=[
            { id: "BLOCK", display: CUFCommon.t("edition-variables.block") }
        ];
        if (destination != "VARIABLESET")
        {
            enableComboboxOptions.push(   { id: "UNBLOCK", display: CUFCommon.t("edition-variables.unblock") })
        }
        form.addCombobox(
            {
                id: "enableCombobox",
                name: CUFCommon.t("default.action-type"),
                values: enableComboboxOptions,
                listeners: {
                    change: function (value) {
                        if (value == "UNBLOCK") {
                            form.setValue("enableEdit", true);
                        }
                        else {
                            form.setValue("enableEdit", false);
                        }
                    }
                },
                value: form.getValue("enableEdit") ? "UNBLOCK" : "BLOCK"
            }
        );
        form.addField({ id: "enableEdit", hidden: true });
        if (destination == "VARIABLESET")
        {
            this.variableSetDest = true;
            form.show("contextCondition");
            form.show("variables");
            if (form.getValue("enableEdit") !== false) {
                form.setValue("enableEdit", false);
            }
            form.disable("enableEdit");
        }
        else
        {
            this.variableSetDest = false;
        }
        if (destination == "FORM" )
        {
            form.show("variables");
        }

        if (form.getValue("enableEdit") == true){
        	form.setValue("enableCombobox", "UNBLOCK");
        } else {
        	form.setValue("enableCombobox", "BLOCK");
        }
    },

    validateForm: function(api){
        if (this.variableSetDest){
            if (api.getFunctionReturnType("contextCondition") != "boolean"){
                api.markError("contextCondition");
                api.showErrorMessage(CUFCommon.t("default.wrong-function-type.boolean"));
                return false;
            }
        }
    }
});