PW.FormActions.create('move-documents-to-process', {
    
    variableInit: function(variable){
        this.variable = variable;
    },
    
    enable: function(){
    	if ( this.target.type == "FORM" ){
    		this.moveDocuments();
    	}
    	else if ( this.target.type == "VARIABLE" ){
    		var me = this;
    		this.variable.on("change", me.moveDocuments, me);
    	}
    },
    
    defaultActions : {
        button: function(button){
        	this.moveDocuments();
        }
    },   
    
    disable: function(){
    	if ( this.target.type == "VARIABLE" ){
    		var me = this;
    		this.variable.off("change", me.moveDocuments, me);
    	}
    },
    
    moveDocuments : function(){
    	var me = this;
        jQuery.ajax({
            url: 'plugin/com.suncode-cuf-components/docs/move',
            contentType: "application/json",
            data: JSON.stringify(me.getParams()),
            method: 'POST',
            success: function( data, textStatus, jQxhr ){
            	if (textStatus == "nocontent"){
            		MessageService.show(CUFCommon.t('action.move-documents-to-process.no-documents-to-move'));
            	}
            	else if (textStatus == "success"){
            		DocumentService.refreshDocuments();
            		MessageService.showSuccess(CUFCommon.t('action.move-documents-to-process.moved-documents') + data);
            	}
            },
            error : function(jqXHR, textStatus, errorThrown){
                messageService.showFailure('Błąd w trakcie pobierania danych z servleta. Komunikat błędu: ' + errorThrown);
            }
        });
    },
    
    getParams : function(){
    	return {
    		sourceProcessId : this.get("sourceProcessId"),
    		targetProcessId : this.get("targetProcessId"),
    		userName: Suncode.getCurrentUser()
    	}
    }
});