/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.comments.validators;

import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.annotation.ValidatorsScript;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
@ValidatorsScript(value="scripts/validators-callbacks/comment-validator-callback.js")
public class CommentValidator {
    @Autowired
    CommentService commentService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("leave-comment-validator")).name("validator.leave-comment.name")).description("validator.leave-comment.desc")).icon((Icon)SilkIconPack.APPLICATION_FORM)).category(new Category[]{Categories.COMMENTS})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}comment-verification")).parameter().id("message").name("validator.leave-comment.param.message.name").description("validator.leave-comment.param.message.desc").type((Type)Types.STRING).optional().create();
    }

    public void validate(UserInfo userInfo, ValidationContext validationContext, ValidationErrors errors, @Param String message) {
        List comments = this.commentService.getCommentsForActivity(validationContext.getActivityId());
        String currentUser = userInfo.getUserName();
        if (!this.checkUserComment(currentUser, comments)) {
            errors.invokeCallback((Object)message);
        }
    }

    private boolean checkUserComment(String userName, List<Comment> comments) {
        for (Comment comment : comments) {
            if (!comment.getUserId().equals(userName)) continue;
            return true;
        }
        return false;
    }
}

