PWE.integrationComponent.registerFormAction( 'user-data-action', {
    apiVersion: 2,
    buildForm: function( form , options ) {
        
        form.addField("username");
        var table = form.addTable({
            tableId: "user-data-table"
        })
        
        table.addCombobox({
            id : "dataTypes",
            values : [
                {id : "FIRSTNAME", display : CUFCommon.t("action.user-data.data-type.firstname")},
                {id : "LASTNAME", display : CUFCommon.t("action.user-data.data-type.lastname")},
                {id : "FULLNAME", display : CUFCommon.t("action.user-data.data-type.fullname")},
                {id : "EMAIL", display : CUFCommon.t("action.user-data.data-type.email")},
                {id : "NUMBER", display : CUFCommon.t("action.user-data.data-type.number")},
                {id : "GROUPSNAMES", display : CUFCommon.t("action.user-data.data-type.groupnames")},
                {id : "POSITIONSNAMES", display : CUFCommon.t("action.user-data.data-type.positionsnames")},
                {id : "POSITIONSSYMBOLS", display : CUFCommon.t("action.user-data.data-type.positionssymbols")},
                {id : "OUNAMES", display : CUFCommon.t("action.user-data.data-type.ounames")},
                {id : "OUSYMBOLS", display : CUFCommon.t("action.user-data.data-type.ousymbols")},
                {id : "SUPERIORSNAMES", display : CUFCommon.t("action.user-data.data-type.superiorsnames")},
                {id : "SUBORDINATES", display : CUFCommon.t("action.user-data.data-type.subordinates")},
                {id : "ALL_SUBORDINATES", display : CUFCommon.t("action.user-data.data-type.all_subordinates")}
            ]
        });
        table.addField("resultVariables");
        form.addField("dataType");
        form.addField("resultVariable");
        if(form.getValue("dataType")){
            table.addRow([
                {id: "dataTypes", value: form.getValue("dataType")}, 
                {id: "resultVariables", value: form.getValue("resultVariable")}
            ]);
        }
        if(form.getValue("dataType")){
            form.setValue("dataType", null);
        }
        if(form.getValue("resultVariable")){
            form.setValue("resultVariable", null);
        }
        form.hide("dataType");
        form.hide("resultVariable");
    }
}); 

PWE.integrationComponent.registerApplication( 'user-data', {
    apiVersion: 2,
    buildForm: function( form , options ) {
        form.addField("login");
        var table = form.addTable({
            tableId: "user-data-table"
        });
        table.addCombobox({
            id : "data",
            values : [
                {id : "FIRSTNAME", display : CUFCommon.t("action.user-data.data-type.firstname")},
                {id : "LASTNAME", display : CUFCommon.t("action.user-data.data-type.lastname")},
                {id : "FULLNAME", display : CUFCommon.t("action.user-data.data-type.fullname")},
                {id : "EMAIL", display : CUFCommon.t("action.user-data.data-type.email")},
                {id : "NUMBER", display : CUFCommon.t("action.user-data.data-type.number")},
                {id : "GROUPSNAMES", display : CUFCommon.t("action.user-data.data-type.groupnames")},
                {id : "POSITIONSNAMES", display : CUFCommon.t("action.user-data.data-type.positionsnames")},
                {id : "POSITIONSSYMBOLS", display : CUFCommon.t("action.user-data.data-type.positionssymbols")},
                {id : "OUNAMES", display : CUFCommon.t("action.user-data.data-type.ounames")},
                {id : "OUSYMBOLS", display : CUFCommon.t("action.user-data.data-type.ousymbols")},
                {id : "SUPERIORSNAMES", display : CUFCommon.t("action.user-data.data-type.superiorsnames")},
                {id : "SUBORDINATES", display : CUFCommon.t("action.user-data.data-type.subordinates")},
                {id : "ALL_SUBORDINATES", display : CUFCommon.t("action.user-data.data-type.all_subordinates")}
            ]
        });
        table.addField("variablesToSave");
    }
});
