/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.servlets;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.cuf.common.db.schemas.ProcessDataDto;
import com.suncode.cuf.common.general.ProcessService;
import com.suncode.cuf.common.general.ProcessStateDto;
import com.suncode.cuf.common.general.ProcessVariableDto;
import com.suncode.cuf.common.general.servlets.DuplicateCheckConfig;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.activity.ActivityType;
import com.suncode.pwfl.workflow.form.AcceptButton;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessState;
import com.suncode.pwfl.workflow.process.ProcessType;
import com.suncode.pwfl.workflow.process.util.CreateProcessResult;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import jakarta.servlet.ServletContext;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/processes"})
public class ProcessController {
    private static final Logger log = LoggerFactory.getLogger(ProcessController.class);
    @Autowired
    private com.suncode.pwfl.workflow.process.ProcessService processService;
    @Autowired
    private VariableFactory variableFactory;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private ProcessService cufProcessService;

    @RequestMapping(value={"processTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ProcessType> getProcessTypes(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.cufProcessService.getProcessTypes(query, start, limit);
    }

    @RequestMapping(value={"activitiesTypes/"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ActivityType> getActivitiesTypes(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return new CountedResult(0L, new ArrayList());
    }

    @RequestMapping(value={"activitiesTypes/{processDefId}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ActivityType> getActivitiesTypes(@PathVariable(value="processDefId") String processDefId, @RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.cufProcessService.getActivitiesTypes(processDefId, query, start, limit);
    }

    @RequestMapping(value={"activityButtons/{processDefId}/{activityDefId}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<AcceptButton> getActivityButtons(@PathVariable(value="activityDefId") String activityDefId, @PathVariable(value="processDefId") String processDefId, @RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.cufProcessService.getAcceptanceButtons(activityDefId, processDefId, query);
    }

    @RequestMapping(value={"activityButtons/"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<AcceptButton> getActivityButtons(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return new CountedResult(0L, new ArrayList());
    }

    @RequestMapping(value={"processVariables/{processDefId}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ProcessVariableDto> getProcessVariables(@PathVariable(value="processDefId") String processDefId, @RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.cufProcessService.getProcessVariables(processDefId, query, start, limit);
    }

    @RequestMapping(value={"processVariables/"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ProcessVariableDto> getProcessVariables(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return new CountedResult(0L, new ArrayList());
    }

    @RequestMapping(value={"duplicates"}, method={RequestMethod.POST})
    @ResponseBody
    public List<String> duplicates(@RequestBody DuplicateCheckConfig duplicateCheckConfig) {
        List<Process> duplicates = this.cufProcessService.getProcessDuplicates(duplicateCheckConfig);
        return duplicates.stream().map(duplicate -> duplicate.getProcessId()).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"data"}, method={RequestMethod.POST})
    public CountedResult<Map<String, Object>> data(@RequestBody ProcessDataDto dto) {
        CountedResult<Process> processes = this.cufProcessService.findProcessesWithFilters(dto);
        return this.cufProcessService.getDataFromProcesses(processes, dto.getVariablesIds());
    }

    @ResponseBody
    @RequestMapping(value={"create/{processDefId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> createProcess(@PathVariable(value="processDefId") String processDefId, @RequestParam Map<String, Object> variablesToSet) {
        try {
            Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefId);
            if (pack == null) {
                return new ResponseEntity((Object)MessageFormat.format("Could not find process \"{0}\".", processDefId), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            if (!this.userHasRightsToCreateProcess(SessionUtils.getLoggedUserName(), processDefId)) {
                return new ResponseEntity((Object)MessageFormat.format("User does not have rights to create process \"{0}\".", processDefId), (HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            ProcessBuilderDefinition processToCreate = this.getProcessBuilderDefinition(pack, processDefId, variablesToSet);
            CreateProcessResult processResult = this.processService.createProcessWithResult(processToCreate);
            if (processResult.isHasOpenActivity()) {
                String path = this.servletContext.getContextPath();
                String processId = processResult.getProcessId();
                String activityId = processResult.getActivityId();
                String url = MessageFormat.format("{0}/ProcesActivity.do?activityId={1}&processKey={2}", path, activityId, processId);
                HttpHeaders headers = new HttpHeaders();
                headers.add("Location", url);
                return new ResponseEntity((MultiValueMap)headers, (HttpStatusCode)HttpStatus.FOUND);
            }
            return new ResponseEntity((Object)MessageFormat.format("Process \"{0}\" has been created correctly, however, no open activities have been found.", processDefId), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private ProcessBuilderDefinition getProcessBuilderDefinition(Package pack, String processDefId, Map<String, Object> rawVariables) {
        ProcessBuilderDefinition processToCreate = new ProcessBuilderDefinition();
        processToCreate.setPackageId(pack.getId());
        processToCreate.setCreator(SessionUtils.getLoggedUserName());
        processToCreate.setProcessDefId(processDefId);
        processToCreate.setVariables(this.resolveVariables(pack, processDefId, rawVariables));
        return processToCreate;
    }

    private Map<String, Object> resolveVariables(Package pack, String processDefId, Map<String, Object> rawVariables) {
        Map variables = this.variableFactory.createVariables(pack, processDefId, null, rawVariables, false);
        log.info("Setting variables in process definition id: " + processDefId);
        Iterator<String> iterator = rawVariables.keySet().iterator();
        while (iterator.hasNext()) {
            String variableId = iterator.next();
            Variable variable = (Variable)variables.get(variableId);
            if (variable != null) {
                rawVariables.put(variableId, variable.getValueAsBasicType());
                log.info("Setting Variable id: " + variableId + ", Variable value: " + variable.getValueAsBasicType());
                continue;
            }
            log.error(MessageFormat.format("Could not find variable \"{0}\" in process definition id \"{1}\"", variableId, processDefId));
            iterator.remove();
        }
        return rawVariables;
    }

    private boolean userHasRightsToCreateProcess(String username, String processDefId) throws SQLException {
        String rightsPath = RightTreeBuilder.builder().system().workflow().processes().create().custom((Object)processDefId).build();
        int hasRights = Authorization.checkRight((String)rightsPath, (String)username, (boolean)false, (boolean)false);
        return hasRights != -1;
    }

    @ResponseBody
    @RequestMapping(value={"/processState"}, method={RequestMethod.GET})
    public String getProcessState(@RequestParam String processId) {
        Process process = this.processService.getProcess(processId, new String[0]);
        return process.getState().getStateText();
    }

    @ResponseBody
    @RequestMapping(value={"/processStateList"}, method={RequestMethod.GET})
    public CountedResult<ProcessStateDto> getProcessStates(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List<ProcessStateDto> processStateDtoList = ProcessController.getAllProcessStateDto();
        return new CountedResult((long)processStateDtoList.size(), processStateDtoList);
    }

    public static List<ProcessStateDto> getAllProcessStateDto() {
        return Arrays.stream(ProcessState.values()).map(state -> new ProcessStateDto(state.name(), state.getStateText(), state.getStateNumber())).toList();
    }
}

