/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.utils.builders;

import com.suncode.cuf.common.db.utils.builders.IndexFiltersBuilder;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.workflow.process.search.RawIndexFilter;
import com.suncode.pwfl.workflow.process.search.SimpleIndexFilter;

public class MSSQLIndexFiltersBuilder
extends IndexFiltersBuilder {
    private static final String COLLATE_SQL_LATIN_1_GENERAL_CP_1_CS_AS = " COLLATE SQL_Latin1_General_CP1_CS_AS ";

    @Override
    public void addEqualFilter(String id, Object value, Type<?> type) {
        if (value == null) {
            if (type == Types.DATE) {
                this.filters.add(new SimpleIndexFilter(id, (Object)"", FilterOperator.EQ));
            } else {
                this.filters.add(new SimpleIndexFilter(id, null, FilterOperator.ISNULL));
            }
        } else if (type == Types.BOOLEAN) {
            this.filters.add(new SimpleIndexFilter(id, value, FilterOperator.EQ));
        } else {
            this.filters.add(new RawIndexFilter(String.format(" idx.%s = '%s' %s ", id, value, COLLATE_SQL_LATIN_1_GENERAL_CP_1_CS_AS)));
        }
    }

    @Override
    public void addNotEqualFilter(String id, Object value, Type<?> type) {
        if (value == null) {
            if (type == Types.DATE) {
                this.filters.add(new SimpleIndexFilter(id, (Object)"", FilterOperator.NOTEQ));
            } else {
                this.filters.add(new SimpleIndexFilter(id, null, FilterOperator.NOTNULL));
            }
        } else {
            this.filters.add(new SimpleIndexFilter(id, value, FilterOperator.NOTEQ));
        }
    }
}

