var cs = ServiceFactory.getCommentsService();

PW.FormValidators.create('leave-comment-validator', {

    callback: function (message) {
        this.message = message;
        this.showCommentWindow();
    },

    showCommentWindow: function () {
        if (!this.commentWindow) {
            this.createCommentWindow();
        }

        let sanitizedMessage = this.sanitizeHtml(this.message);
        this.commentWindow.down('label').setText(sanitizedMessage, false);
        this.commentWindow.show();
    },

    createCommentWindow: function () {
        var me = this;

        var commentWindowDef = new Ext4.define('Client.msg.commentWindow', {

            extend: 'Ext4.window.Window',
            width: CUFCommon.getCommentWindowWidth(),
            layout: 'fit',
            modal: true,
            buttonAlign: 'right',
            closable: false,

            title: CUFCommon.t('leave-comment.window-title'),

            items: [{
                xtype: 'form',
                frame: false,
                border: 0,

                layout: {
                    type: 'hbox',
                    align: 'middle'
                },

                fieldDefaults: {
                    msgTarget: 'side',
                    labelWidth: 70
                },

                items: [{
                    xtype: 'container',
                    flex: 1,
                    padding: 10,
                    layout: {
                        type: 'vbox',
                        align: 'stretch'
                    },
                    items: [
                        {
                            xtype: 'label',
                            margin: '0 0 20 0'
                        },
                        {
                            xtype: 'textareafield',
                            itemId: 'commentWindow_textarea',
                            name: 'comment',
                            allowBlank: false,
                            flex: 1,
                            maxLength: 4000,
                            maxLengthText: CUFCommon.t('leave-comment.max-length-text')
                        }
                    ]
                }]
            }],

            buttons: [{
                text: CUFCommon.t('leave-comment.accept-button-name'),
                itemId: 'acceptButton',
                handler: function () {
                    var isValid = this.up('window').down('form').getForm().isValid();
                    if (isValid) {
                        var cfg = {
                            success: function () {
                                this.closeWindow();
                                this.confirm();
                            },
                            failure: function (response) {
                                Ext4.Msg.show({
                                    title: CUFCommon.t("leave-comment.errortitle"),
                                    msg: CUFCommon.t("leave-comment.errormsg") + response,
                                    buttons: Ext4.Msg.OK,
                                    icon: Ext4.Msg.ERROR,
                                });
                            },
                            scope: me
                        };
                        cs.add(this.up('window').down('textareafield').getValue(), cfg);
                    }
                },
            },
                {
                    text: CUFCommon.t('leave-comment.cancel-button-name'),
                    itemId: 'cancelButton',
                    handler: this.closeWindow,
                    scope: me
                }]
        });
        this.commentWindow = Ext4.create('Client.msg.commentWindow');
    },

    closeWindow: function () {
        this.commentWindow.hide();
    },

    sanitizeHtml: function (html) {
        if (!html || typeof html !== 'string') {
            return '';
        }

        let allowedTags = ['BR', 'B', 'I', 'U', 'STRONG', 'EM', 'P'];
        let parser = new DOMParser();
        let document = parser.parseFromString(html, 'text/html');

        document.body.querySelectorAll('*').forEach(element => {
            if (!allowedTags.includes(element.tagName)) {
                element.remove();
            } else {
                [...element.attributes].forEach(attribute => element.removeAttribute(attribute.name));
            }
        });

        return document.body.innerHTML;
    }
});