PWE.integrationComponent.registerValidator( 'verify-documents', {
    apiVersion: 2,
    buildForm: function( form ) {
        form.addCombobox({
            id : "verificationMode",
            values : [{id : "activity", display : CUFCommon.t("verify-documents.activity")},
                      {id : "stage", display : CUFCommon.t("verify-documents.stage")},
                      {id : "process", display : CUFCommon.t("verify-documents.process")}]
        });

        var conditionsTable = form.addTable({
            id : "conditionsTable",
            name: CUFCommon.t("verify-documents.conditionsTable.name"),
            description: CUFCommon.t("verify-documents.conditionsTable.desc")
        });
        CufComp.addComboboxClassList("documentClassName", null, conditionsTable);
        conditionsTable.addCombobox({
            id: "conditionType",
            values: [
                { id: "=", display: "=" },
                { id: "!=", display: "!=" },
                { id: "<", display: "<" },
                { id: ">", display: ">" },
                { id: "<=", display: "<=" },
                { id: ">=", display: ">=" }
            ]
        });

        conditionsTable.addField("documentCount");
        conditionsTable.addField("fileNameRegExp");

        form.addCombobox({id: "conditionalOperator",
            values: [
                { id: "AND", display: "AND", description: CUFCommon.t("verify-documents.conditionalOperator.param.and.desc") },
                { id: "OR", display: "OR", description: CUFCommon.t("verify-documents.conditionalOperator.param.or.desc") }
            ]
        });
        form.addField({
            id: "confirmation",
            hidden: false,
            listeners: {
                change: function( value ) {
                    if ( value ) {
                        form.show("messageWindowTitle");
                        form.show("acceptButtonName");
                        form.show("cancelButtonName");
                        form.show("messageIconType");
                    }  else {
                        form.hide("messageWindowTitle");
                        form.hide("acceptButtonName");
                        form.hide("cancelButtonName");
                        form.hide("messageIconType");
                    }
                }
            }
        });
        form.setNotEmpty("documentClassName", true);
        form.setNotEmpty("conditionType", true);
        form.setNotEmpty("documentCount", true);
        form.addField({
            id: "messageWindowTitle",
            hidden: true
        });
        form.addField({
            id: "acceptButtonName",
            hidden: true
        });
        form.addField({
            id: "cancelButtonName",
            hidden: true
        });
        form.addCombobox({
            id: "messageIconType",
            values: [
                {id: "QUESTION", display : CUFCommon.t("validator.verify-documents.messageIconType.question")},
                {id: "INFO", display : CUFCommon.t("validator.verify-documents.messageIconType.info")},
                {id: "ERROR", display : CUFCommon.t("validator.verify-documents.messageIconType.error")},
                {id: "WARNING", display : CUFCommon.t("validator.verify-documents.messageIconType.warning")},
                {id: "SUCCESS", display : CUFCommon.t("validator.verify-documents.messageIconType.success")}
            ]
        });
        form.addField({
            id: "message",
            hidden: false
        });

        if ( form.getValue("confirmation") ) {
            form.show("messageWindowTitle");
            form.show("acceptButtonName");
            form.show("cancelButtonName");
            form.show("messageIconType");
        }  else {
            form.hide("messageWindowTitle");
            form.hide("acceptButtonName");
            form.hide("cancelButtonName");
            form.hide("messageIconType");
        }
    }
});
