PWE.integrationComponent.registerApplication("cuf.common.general.applications.UpdateProcessApp", {
    apiVersion: 2,
    buildForm: function (form) {
        form.addCombobox({
            id: "updateMode",
            values: [
                {id: "CANCEL_ACTIVITY", display: CUFCommon.t("update-processes-app.cancel-activity")},
                {id: "ACCEPT_ACTIVITY", display: CUFCommon.t("update-processes-app.accept-activity")},
                {id: "UPDATE_ACTIVITY", display: CUFCommon.t("update-processes-app.update-activity")},
                {id: "UPDATE_PROCESS", display: CUFCommon.t("update-processes-app.update-process")}
            ],
            listeners: {
                change: function (value) {
                    switch (value) {
                        case "CANCEL_ACTIVITY":
                            toggleCancelActivityFields(form);
                            break;
                        case "ACCEPT_ACTIVITY":
                            toggleAcceptActivityFields(form);
                            break;
                        case "UPDATE_ACTIVITY":
                            toggleUpdateActivityFields(form);
                            break;
                        case "UPDATE_PROCESS":
                            toggleUpdateProcessFields(form);
                            break;
                    }

                    filterTable.clear();
                    updateTable.clear();
                }
            }
        });

        form.addCombobox({
            id: "processDefId",
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/processTypes",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "processDefId",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("default.process-name"),
                    field: "name"
                }
            ],
            valueField: "processDefId",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            forceSelection: false,
            listeners: {
                change: function (value) {
                    const activitiesUrl = "plugin/com.suncode-cuf-components/processes/activitiesTypes/";
                    const variablesUrl = "plugin/com.suncode-cuf-components/processes/processVariables/";

                    if (value) {
                        form.enable("activityDefId");
                        form.enable("updateTable");
                        form.enable("filterTable");
                    } else {
                        form.disable("activityDefId");
                        form.disable("updateTable");
                        form.disable("filterTable");
                    }

                    form.resetValue("activityDefId");
                    filterTable.clear();
                    updateTable.clear();

                    if (!form.hasVariableValue("processDefId") && !form.hasFunctionValue("processDefId")) {
                        activityDefId.setUrl(activitiesUrl + value);
                        variablesFilter.setUrl(variablesUrl + value);
                        variablesToSet.setUrl(variablesUrl + value);
                    }
                }
            }
        });

        const activityDefId = form.addCombobox({
            id: "activityDefId",
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/activitiesTypes/" + form.getValue("processDefId"),
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "activityDefId",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("default.activity-name"),
                    field: "name"
                }
            ],
            valueField: "activityDefId",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            forceSelection: false,
            listeners: {
                change: function (value) {
                    let activityButtonsUrl = "plugin/com.suncode-cuf-components/processes/activityButtons/";

                    if (value) {
                        form.enable("acceptButtonId");
                        activityButtonsUrl = activityButtonsUrl + form.getValue("processDefId") + "/" + value;
                    } else {
                        form.disable("acceptButtonId");
                    }

                    form.resetValue("acceptButtonId");

                    if (!form.hasVariableValue("activityDefId") && !form.hasFunctionValue("activityDefId")) {
                        acceptButtonId.setUrl(activityButtonsUrl);
                    }
                }
            }
        });

        form.addField("allowMultipleProcesses");
        form.addField("includeClosedActivities");

        const filterTable = form.addTable({
            id: "filterTable",
            name: CUFCommon.t("update-processes-app.filter-table.label")
        });

        const variablesFilter = filterTable.addCombobox({
            id: "variablesFilter",
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/processVariables/" + form.getValue("processDefId"),
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "id",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-variable.name"),
                    field: "name"
                }
            ],
            valueField: "id",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            forceSelection: false
        });

        filterTable.addField("valuesFilter");

        const updateTable = form.addTable({
            id: "updateTable",
            name: CUFCommon.t("update-processes-app.update-table.label")
        });

        const variablesToSet = updateTable.addCombobox({
            id: "variablesToSet",
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/processVariables/" + form.getValue("processDefId"),
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "id",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-variable.name"),
                    field: "name"
                }
            ],
            valueField: "id",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            forceSelection: false
        });

        updateTable.addField("valuesToSet");

        const acceptButtonId = form.addCombobox({
            id: "acceptButtonId",
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/activityButtons/" + form.getValue("processDefId") + "/" + form.getValue("activityDefId"),
                fields: [
                    {
                        name: "buttonName",
                        type: "string"
                    },
                    {
                        name: "actionName",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-accept-button.name"),
                    field: "buttonName"
                }
            ],
            valueField: "actionName",
            displayField: "buttonName",
            sort: [{
                property: "buttonName",
                direction: "ASC"
            }],
            forceSelection: false
        });

        form.addCombobox({
            id: "archivedDataModificationCommentType",
            values: [
                {id: "SINGULAR", display: CUFCommon.t("update-processes-app.singular")},
                {id: "COLLECTIVE", display: CUFCommon.t("update-processes-app.collective")}
            ]
        });

        form.addCombobox({
            id: "customUserCommentType",
            values: [
                {id: "SINGULAR", display: CUFCommon.t("update-processes-app.everyActivity")},
                {id: "COLLECTIVE", display: CUFCommon.t("update-processes-app.lastActivity")}
            ]
        });

        form.addField("customUserCommentValue");

        form.addCombobox({
            id: "commentOwner",
            values: [
                {id: "ADMIN", display: CUFCommon.t("update-processes-app.admin")},
                {id: "USER", display: CUFCommon.t("update-processes-app.user")}
            ]
        });

        switch (form.getValue("updateMode")) {
            case "CANCEL_ACTIVITY":
                toggleCancelActivityFields(form);
                break;
            case "ACCEPT_ACTIVITY":
                toggleAcceptActivityFields(form);
                break;
            case "UPDATE_ACTIVITY":
                toggleUpdateActivityFields(form);
                break;
            case "UPDATE_PROCESS":
                toggleUpdateProcessFields(form);
                break;
        }

        function toggleCancelActivityFields(form) {
            form.show("activityDefId");
            form.setNotEmpty("activityDefId", true);
            form.hide("acceptButtonId");
            form.setNotEmpty("acceptButtonId", false);
        }

        function toggleAcceptActivityFields(form) {
            form.show("activityDefId");
            form.setNotEmpty("activityDefId", true);
            form.show("acceptButtonId");
            form.setNotEmpty("acceptButtonId", true);
        }

        function toggleUpdateActivityFields(form) {
            form.show("activityDefId");
            form.setNotEmpty("activityDefId", true);
            form.hide("acceptButtonId");
            form.setNotEmpty("acceptButtonId", false);
        }

        function toggleUpdateProcessFields(form) {
            form.hide("activityDefId");
            form.setNotEmpty("activityDefId", false);
            form.hide("acceptButtonId");
            form.setNotEmpty("acceptButtonId", false);
        }
    },
    validateForm: function (api) {
        return true;
    }
});