PWE.integrationComponent.registerFormAction('style-variables', {
    apiVersion: 2,
    destination: '',
    buildForm: function (form, options) {

        this.destination = options.destination;
        if (this.destination === "FORM") {
            form.addField({id: "variables", notEmpty: true});
        }

        form.addCombobox({
            id: "styleDestination",
            values: [
                {id: "FIELD", display: CUFCommon.t('style-variables.style-destination.field')},
                {id: "LABEL", display: CUFCommon.t('style-variables.style-destination.label')},
                {id: "FIELDLABEL", display: CUFCommon.t('style-variables.style-destination.fieldlabel')}
            ]
        });
        form.addCombobox({
            id: "stylingType",
            values: [
                {id: "BASIC", display: CUFCommon.t('style-variables.styling-types.basic')},
                {id: "ADVANCED", display: CUFCommon.t('style-variables.styling-types.advanced')}
            ],
            listeners: {
                change: function (value) {
                    if (value === "ADVANCED") {
                        form.show("style");
                        form.resetValue("fontSize");
                        form.hide("fontSize");
                        form.resetValue("fontColor");
                        form.hide("fontColor");
                        form.resetValue("backgroundColor");
                        form.hide("backgroundColor");
                        form.resetValue("bold");
                        form.hide("bold");
                        form.resetValue("italic");
                        form.hide("italic");
                        form.resetValue("useSystemThemeFontColor");
                        form.hide("useSystemThemeFontColor");
                        form.resetValue("useSystemThemeBackgroundColor");
                        form.hide("useSystemThemeBackgroundColor");
                    } else {
                        form.show("fontSize");
                        form.setValue("fontSize", 12);
                        form.show("fontColor");
                        form.setValue("fontColor", "#000000");
                        form.show("backgroundColor");
                        form.setValue("backgroundColor", "#000000");
                        form.show("bold");
                        form.setValue("bold", false);
                        form.show("italic");
                        form.setValue("italic", false);
                        form.resetValue("style");
                        form.hide("style");
                        form.setValue("useSystemThemeFontColor", false);
                        form.show("useSystemThemeFontColor");
                        form.setValue("useSystemThemeBackgroundColor", false);
                        form.show("useSystemThemeBackgroundColor");
                    }
                }
            }
        });
        form.addField("style");
        form.addField("fontSize");
        form.addField({
            id: "useSystemThemeFontColor",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.hide("fontColor");
                    } else {
                        form.show("fontColor");
                    }
                }
            }
        });
        form.addColorPicker("fontColor");
        form.addField({
            id: "useSystemThemeBackgroundColor",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.hide("backgroundColor");
                    } else {
                        form.show("backgroundColor");
                    }
                }
            }
        });
        form.addColorPicker("backgroundColor");
        form.addField("bold");
        form.addField("italic");
        form.addField("restoreDefaultStyle");

        if (form.getValue("stylingType") === "ADVANCED") {
            form.show("style");
            form.hide("fontSize");
            form.hide("fontColor");
            form.hide("backgroundColor");
            form.hide("bold");
            form.hide("italic");
            form.hide("useSystemThemeFontColor");
            form.hide("useSystemThemeBackgroundColor");
        } else {
            form.show("fontSize");
            form.show("fontColor");
            form.show("backgroundColor");
            form.show("bold");
            form.show("italic");
            form.hide("style");
            form.show("useSystemThemeFontColor");
            form.show("useSystemThemeBackgroundColor");

            if (form.getValue("useSystemThemeFontColor")) {
                form.hide("fontColor");
            }

            if (form.getValue("useSystemThemeBackgroundColor")) {
                form.hide("backgroundColor");
            }
        }
    },

    validateForm: function (api) {
        let error = false;

        if (!api.hasVariableValue("fontSize") && !api.hasFunctionValue("fontSize") && api.getValue("fontSize")) {
            if (api.getValue("fontSize") > 30) {
                api.showErrorMessage(CUFCommon.t("style-variables.too-large-font"));
                api.markError("fontSize");
                error = true;
            } else if (api.getValue("fontSize") <= 5) {
                api.showErrorMessage(CUFCommon.t("style-variables.too-small-font"));
                api.markError("fontSize");
                error = true;
            }
        }

        if (this.destination === "FORM") {
            api.getVariableType("variables").forEach(function (type, index) {
                if (type.indexOf("[]") > 0) {
                    api.showErrorMessage(CUFCommon.t("style-variables.only-header-variables"));
                    api.markError("variables", index);
                    error = true;
                }
            });
        }

        return !error;
    }
});