PWE.integrationComponent.registerSystemFunction('replaceMany', [{
	type: 'string',
	id: 'orginalString',
	array: false
}, {
	type: 'string',
	id: 'replaceOptions',
	array: false
}, {
	type: 'string',
	id: 'replaceFrom',
	array: true
},
{
	type: 'string',
	id: 'replaceTo',
	array: false
}], {
	apiVersion: 2,
	buildForm: function(form) {
		form.addField({
			id: "orginalString",
			notEmpty: false,
			optional: false
		});

		form.addCombobox({
			id: "replaceOptions",
			optional: false,
			values: [
				{ id: "WINDOWS", display: CUFCommon.t("function.replaceMany.replaceOptions.windows") },
				{ id: "LINUX", display: CUFCommon.t("function.replaceMany.replaceOptions.linux") },
				{ id: "CUSTOM", display: CUFCommon.t("function.replaceMany.replaceOptions.custom") }
			],
			listeners: {
				change: function() {
					showCustomStringField(form);
				}
			}
		});

		form.addField({
			id: "replaceFrom",
			hidden: true,
			notEmpty: false,
			optional: true
		});

		form.addField({
			id: "replaceTo",
			notEmpty: false,
			optional: false
		});
		showCustomStringField(form);
	},
	validateForm: function(form) {
		var windowsChars = ["<", ">", ":", "\"", "/", "|", "\\", "?", "*"];
		var replaceToValue = form.getValue("replaceTo");

		if (form.getValue("replaceOptions") == "WINDOWS") {
			var notContain = true;
			windowsChars.forEach(function(item) {
				if (replaceToValue.includes(item)) {
					form.markError("replaceTo");
					form.showErrorMessage(CUFCommon.t("function.replaceMany.replaceTo.windows.error"));
					notContain = false;
					return;
				}
			});
			return notContain;
		}
		if (form.getValue("replaceOptions") == "LINUX" && replaceToValue.includes("/")) {
			form.markError("replaceTo");
			form.showErrorMessage(CUFCommon.t("function.replaceMany.replaceTo.linux.error"));
			return false;
		}
	}
});
function showCustomStringField(form) {
	if (form.getValue("replaceOptions").indexOf('CUSTOM') > -1) {
		form.show("replaceFrom");
	} else {
		form.hide("replaceFrom");
		form.resetArray("replaceFrom");
	}
}