/**
 * Form of generate-document action
 */

PWE.integrationComponent.registerFormAction( 'generate-document', {
    apiVersion : 2,
    buildForm: function( form , options ) {
        form.addCombobox({
            id : "fileDestination",
            value : "archive",
            values : [
                { id: "archive", display: CUFCommon.t("generate-document.file-destination.archive") },
                { id: "preview", display: CUFCommon.t("generate-document.file-destination.preview") }
            ],
            listeners: {
                change: function(value) {
                    if (value === 'preview') {
                        form.hide('show');
                        form.hide('newVersion');
                        form.hide('format');
                        form.setValue("format", "PDF");
                        form.hide('documentName');
                        form.hide('message');
                        form.hide("documentClass");
                        form.hide("attachToProcess");
                        form.hide("successful-generation-message-settings-fs");
                    } else {
                        form.show('show');
                        form.show('newVersion');
                        form.show('format');
                        form.show('documentName');
                        form.show('message');
                        form.show('documentClass');
                        form.show("attachToProcess");
                        form.show("successful-generation-message-settings-fs");
                    }
                }
            }
        });
        form.addField({
            id: "attachToProcess",
            notEmpty: true
        });
        form.addCombobox({
            id : "format",
            values : [
            	{ id: "PDF", display: "PDF" },
            	{ id: "DOCX", display: "DOCX" }
            ]
        });
        form.addField("show");
        form.addField("message");
        CufComp.addComboboxClassList("documentClass", null, form);
        form.addCombobox({
            id : "templateSource",
            values : [
                { id: "PROCESS_TEMPLATE", display: CUFCommon.t("generate-document.template-source.process-template") },
                { id: "PROCESS_ATTACHED_DOCUMENT_TEMPLATE", display: CUFCommon.t("generate-document.template-source.process-attached-document-template") }
            ],
			listeners: {
				change: function(value) {
					if (value === "PROCESS_ATTACHED_DOCUMENT_TEMPLATE"){
			        	form.hide("template");
			        	form.resetValue("template");
			        	form.setNotEmpty("template", false);
			        	form.show("documentTemplateClassName");
			        	form.setNotEmpty("documentTemplateClassName", true);
			        }
			        else{
			        	form.show("template");
			        	form.setNotEmpty("template", true);
			        	form.hide("documentTemplateClassName");
			        	form.resetValue("documentTemplateClassName");
			        	form.setNotEmpty("documentTemplateClassName", false);
			        }
				}
			}
        });
        CufComp.addComboboxClassList("documentTemplateClassName", null, form);
        form.addField({
            id: "template",
            notEmpty: true
        });

        form.addField({
            id: "newVersion",
            notEmpty: true
        });
        form.addField("documentName");
        form.addCombobox({
            id: "documentOwner",
            values: [
                {
                    id: "Administrator",
                    display: CUFCommon.t("generate-document.documentOwner.administrator")
                },
                {
                    id: "LoggedUser",
                    display: CUFCommon.t("generate-document.documentOwner.loggedUser")
                }
            ]
        });

        let successfulGenerationMessageSettings = form.addFieldSet({
            id: "successful-generation-message-settings-fs",
            collapsible: true,
            collapsed: false,
            title: CUFCommon.t("generate-document.successful-file-generation-message-settings.name")
        });

        successfulGenerationMessageSettings.addField({
            id: "successfulFileGenerationMessage",
            listeners: {
                change: function(value) {
                    if (value) {
                        toggleFieldsWhenSuccessfulFileGenerationMessageIsTrueOrVariableOrFunction(successfulGenerationMessageSettings);
                    } else {
                        toggleFieldsWhenSuccessfulFileGenerationMessageIsFalse(successfulGenerationMessageSettings);
                    }
                }
            }
        });
        successfulGenerationMessageSettings.addField("messageContent");

        var mappingTable = form.addTable({
            tableId: "mappingTable"
        });
        mappingTable.addField("mappingsIds");
        mappingTable.addField("mappingsValues");
        if (form.getValue("fileDestination") === "preview"){
        	form.hide('show');
            form.hide('newVersion');
            form.hide('format');
            form.hide('documentName');
            form.hide('message');
            form.hide('documentClass');
            form.hide("attachToProcess");
            form.hide("successful-generation-message-settings-fs");
        }
        if (form.getValue("templateSource") === "PROCESS_ATTACHED_DOCUMENT_TEMPLATE"){
        	form.hide("template");
        	form.resetValue("template");
        	form.setNotEmpty("template", false);
        	form.show("documentTemplateClassName");
        	form.setNotEmpty("documentTemplateClassName", true);
        }
        else {
        	form.show("template");
        	form.setNotEmpty("template", true);
        	form.hide("documentTemplateClassName");
        	form.resetValue("documentTemplateClassName");
        	form.setNotEmpty("documentTemplateClassName", false);
        }
        if (successfulGenerationMessageSettings.getValue("successfulFileGenerationMessage")){
            toggleFieldsWhenSuccessfulFileGenerationMessageIsTrueOrVariableOrFunction(successfulGenerationMessageSettings);
        } else {
            toggleFieldsWhenSuccessfulFileGenerationMessageIsFalse(successfulGenerationMessageSettings);
        }
    }
});

function toggleFieldsWhenSuccessfulFileGenerationMessageIsTrueOrVariableOrFunction(form) {
    form.setNotEmpty("messageContent", true);
    form.show("messageContent");
}

function toggleFieldsWhenSuccessfulFileGenerationMessageIsFalse(form) {
    form.setNotEmpty("messageContent", false);
    form.hide("messageContent");
}

PWE.integrationComponent.registerApplication('generate-document-app', {
    apiVersion : 2,
    buildForm: function(form) {
        form.addCombobox({
            id : "format",
            values : [
                { id: "PDF", display: "PDF" },
                { id: "DOCX", display: "DOCX" }
            ]
        });
        CufComp.addComboboxClassList("documentClass", null, form);

        var templateSettings = form.addFieldSet({
            id: "template-settings-fs",
            collapsible: false,
            collapsed: false,
            title: CUFCommon.t("generate-document.template-receiving-settings.fieldset.title")
        });

        templateSettings.addCombobox({
            id : "templateSource",
            values : [
                { id: "PROCESS_TEMPLATE", display: CUFCommon.t("generate-document.template-source.process-template") },
                { id: "PROCESS_ATTACHED_DOCUMENT_TEMPLATE", display: CUFCommon.t("generate-document.template-source.process-attached-document-template") },
                { id: "ARCHIVE_TEMPLATE", display: CUFCommon.t("generate-document.template-source.archive-template") }
            ],
			listeners: {
				change: function(value) {
                    if (value === "PROCESS_TEMPLATE") {
                        toggleFieldsWhenTemplateSourceIsProcessTemplate(templateSettings, indexTable);
                    } else if (value === "PROCESS_ATTACHED_DOCUMENT_TEMPLATE") {
                        toggleFieldsWhenTemplateSourceIsProcessAttachedDocumentTemplate(templateSettings, indexTable);
                    } else if (value === "ARCHIVE_TEMPLATE") {
                        toggleFieldsWhenTemplateSourceIsArchiveTemplate(templateSettings);
                    } else if (templateSettings.hasFunctionValue("templateSource") || templateSettings.hasVariableValue("templateSource")) {
                        toggleFieldsWhenTemplateSourceIsFunctionOrVariable(templateSettings, indexTable);
                    } else {
                        toggleFieldsWhenTemplateSourceIsUndefined(templateSettings, indexTable);
                    }
				}
			}
        });
        CufComp.addComboboxClassList("documentTemplateClassName", null, templateSettings);
        templateSettings.addField("template");

        const indexTable = templateSettings.addTable({
            id: "indexTable",
            name: CUFCommon.t("generate-document.template-source.index-table.filtering-by-indexes"),
        }, 4);

        buildComboboxClassAndIndexList(templateSettings, indexTable);

        form.addField({
            id: "attachToProcess",
            notEmpty: true
        });
        form.addField({
            id: "newVersion",
            notEmpty: true
        });
        form.addField("documentName");
        var mappingTable = form.addTable({
            tableId: "mappingTable"
        });

        mappingTable.addField("mappingsIds");
        mappingTable.addField("mappingsValues");

        afterTemplateSettingsFieldSetLoad(templateSettings, indexTable);
    }
});

function buildComboboxClassAndIndexList(form, indexTable) {
    CufComp.addComboboxClassList("documentClassArchive", {
        change: function (value) {
            const position = form.getFieldPosition("indexName");
            form.removeField("indexName");
            if (form.hasVariableValue("documentClassArchive") || form.hasFunctionValue("documentClassArchive") || value === null) {
                indexTable.addField("indexName", position)
            } else {
                CufComp.addComboboxClassIndexList("indexName", value, null, indexTable, 0);
            }
            indexTable.clear();
        }
    }, form, 3);

    CufComp.addComboboxClassIndexList("indexName", form.getValue("documentClassArchive"), null, indexTable, 0);
    if (form.hasVariableValue("documentClassArchive") || form.hasFunctionValue("documentClassArchive")) {
        indexTable.addField("indexName")
    } else {
        CufComp.addComboboxClassIndexList("indexName", form.getValue("documentClassArchive"), null, indexTable, 0);
    }
    indexTable.addField("indexValue");
}

function afterTemplateSettingsFieldSetLoad(form, indexTable) {
    if (form.getValue("templateSource") === "PROCESS_TEMPLATE") {
        toggleFieldsWhenTemplateSourceIsProcessTemplate(form, indexTable);
    } else if (form.getValue("templateSource") === "PROCESS_ATTACHED_DOCUMENT_TEMPLATE") {
        toggleFieldsWhenTemplateSourceIsProcessAttachedDocumentTemplate(form, indexTable);
    } else if (form.getValue("templateSource") === "ARCHIVE_TEMPLATE") {
        toggleFieldsWhenTemplateSourceIsArchiveTemplate(form);
    } else if (form.hasFunctionValue("templateSource") ||
        form.hasVariableValue("templateSource")) {
        toggleFieldsWhenTemplateSourceIsFunctionOrVariable(form, indexTable);
    } else {
        toggleFieldsWhenTemplateSourceIsUndefined(form, indexTable);
    }
}

function toggleFieldsWhenTemplateSourceIsProcessTemplate(form, indexTable) {
    form.show("template");
    form.setNotEmpty("template", true);
    form.hide("documentTemplateClassName");
    form.resetValue("documentTemplateClassName");
    form.setNotEmpty("documentTemplateClassName", false);
    indexTable.clear();
    form.hide("documentClassArchive");
    form.resetValue("documentClassArchive", true);
    form.setNotEmpty("documentClassArchive", false);
    form.hide("indexTable");
}

function toggleFieldsWhenTemplateSourceIsProcessAttachedDocumentTemplate(form, indexTable) {
    form.hide("template");
    form.resetValue("template");
    form.setNotEmpty("template", false);
    form.show("documentTemplateClassName");
    form.setNotEmpty("documentTemplateClassName", true);
    indexTable.clear();
    form.hide("documentClassArchive");
    form.resetValue("documentClassArchive", true);
    form.setNotEmpty("documentClassArchive", false);
    form.hide("indexTable");
}

function toggleFieldsWhenTemplateSourceIsArchiveTemplate(form) {
    form.hide("template");
    form.resetValue("template");
    form.setNotEmpty("template", false);
    form.hide("documentTemplateClassName");
    form.resetValue("documentTemplateClassName");
    form.setNotEmpty("documentTemplateClassName", false);
    form.show("documentClassArchive");
    form.setNotEmpty("documentClassArchive", true);
    form.show("indexTable");
}

function toggleFieldsWhenTemplateSourceIsFunctionOrVariable(form, indexTable) {
    form.show("template");
    form.resetValue("template");
    form.setNotEmpty("template", false);
    form.show("documentTemplateClassName");
    form.resetValue("documentTemplateClassName");
    form.setNotEmpty("documentTemplateClassName", false);
    indexTable.clear();
    form.show("documentClassArchive");
    form.resetValue("documentClassArchive", true);
    form.setNotEmpty("documentClassArchive", false);
    form.show("indexTable");
}

function toggleFieldsWhenTemplateSourceIsUndefined(form, indexTable) {
    form.hide("template");
    form.resetValue("template");
    form.setNotEmpty("template", false);
    form.hide("documentTemplateClassName");
    form.resetValue("documentTemplateClassName");
    form.setNotEmpty("documentTemplateClassName", false);
    indexTable.clear();
    form.hide("documentClassArchive");
    form.resetValue("documentClassArchive", true);
    form.setNotEmpty("documentClassArchive", false);
    form.hide("indexTable");
}

