PWE.integrationComponent.registerFormAction("execute-datasource-action", {
  apiVersion: 2,
  buildForm: function(form, options) {
    this.destination = options.destination;
    handle(form, this.destination);
  }
});

function handle(form, destination) {
  DataSource.buildDataSourceSelectionCombobox(
      form,
      DataSource.Operations.ALL,
      "datasource",
      "datasources"
  );

  DataSource.buildParametersForNonDatachooser(form, {
    datasourceParamId: "datasource",
    datasourcesParamId: "datasources",
    datasourceInputParametersId: "datasourceInputParametersId",
    datasourceInputParametersValue: "datasourceInputParametersValue",
    datasourceOutputParametersId: "datasourceOutputParametersId",
    datasourceOutputParametersValue: "datasourceOutputParametersValue"
  });

  form.addCombobox({
    id: "manyValuesHandler",
    forceSelection: true,
    values:
        destination !== "VARIABLESET"
            ? [
              {
                id: "block",
                display: CUFCommon.t("datasource.handleManyVals.block.name"),
                description: CUFCommon.t("datasource.handleManyVals.block.desc")
              },
              {
                id: "first",
                display: CUFCommon.t("datasource.handleManyVals.first.name"),
                description: CUFCommon.t("datasource.handleManyVals.first.desc")
              },
              {
                id: "unique",
                display: CUFCommon.t("datasource.handleManyVals.unique.name"),
                description: CUFCommon.t("datasource.handleManyVals.unique.desc")
              }
            ]
            : [
              {
                id: "block",
                display: CUFCommon.t("datasource.handleManyVals.block.name"),
                description: CUFCommon.t("datasource.handleManyVals.block.desc")
              },
              {
                id: "first",
                display: CUFCommon.t("datasource.handleManyVals.first.name"),
                description: CUFCommon.t("datasource.handleManyVals.first.desc")
              }
            ]
  });
  if (destination !== "VARIABLESET") {
    form.addField("overwriteData");
    form.hide("overwriteData");
    form.addCombobox({
      id : "wayOfAdding",
      values : [
        {id : "OVERWRITE_ALL_COLUMNS", display : CUFCommon.t("predefined.wayOfAdding.overwrite_all_columns")},
        {id : "OVERWRITE_UPDATED_COLUMNS", display : CUFCommon.t("predefined.wayOfAdding.overwrite_updated_column")},
        {id : "ADD", display : CUFCommon.t("predefined.wayOfAdding.add")},
        {id : "OVERWRITE_ALL_COLUMNS_OR_CLEAR_IF_NO_RESULTS", display : CUFCommon.t("predefined.wayOfAdding.overwrite_all_columns_or_clear_if_no_results")}
      ]
    });
    if (form.getValue("wayOfAdding") == "UNSET"){
      let overwrite = form.getValue("overwriteData", false);
      form.setValue("wayOfAdding", overwrite ? "OVERWRITE_ALL_COLUMNS" : "ADD");
    }
  }

  let messageParamFieldSet = form.addFieldSet({
    title: CUFCommon.t("datasource.label.messageParamFieldSet"),
  });
  messageParamFieldSet.addField("datasourceShowMessage");
  messageParamFieldSet.addField("datasourceMessage");

  form.addField("saveFormAfterActionExecution");
}
