/**
 * PWE form of AttachedDocumentsValidator.
 */
PWE.integrationComponent.registerFormAction( 'attach-document', {
    apiVersion: 2,
    buildForm: function( form , options ) {
    	form.addField("showIndexes");
        form.addField("checkRights");
        form.addField("autoSelectFirst");
        form.addField({
            id: "documentClassIdList",
            hidden: true,
            value: []
        });
        let documentClassIdList = form.getValue("documentClassIdList");
        if (Array.isArray(documentClassIdList) && documentClassIdList.length) {
            form.show("documentClassIdList");
        } else {
            CufComp.addComboboxClassList("documentClassNameList", null, form);
        }
        form.addField({id: "refreshAfterAdd",hidden:true});
        form.addCombobox({
        	id: "savingAsNewVersion",
        	values: [
        		{id: "TrueAndEditable", display : CUFCommon.t('action.attach-document.saving-as-new-version.yes-and-editable')},
        		{id: "TrueAndUneditable", display : CUFCommon.t('action.attach-document.saving-as-new-version.yes-and-uneditable')},
        		{id: "FalseAndEditable", display : CUFCommon.t('action.attach-document.saving-as-new-version.no-and-editable')},
        		{id: "FalseAndUneditable", display : CUFCommon.t('action.attach-document.saving-as-new-version.no-and-uneditable')}
        	]
        });
        form.addField("callback");
        form.addField("allowedExtensions");
    }
}); 
