PW.FormActions.create('usernames-to-fullnames-action', {
	init: function() {
		this.targetVar = this.get("targetVariable");
		this.failureMessage = this.get("failureMessage");
	},
	variableInit: function(variable) {
		this.sourceVar = variable;
	},
	variableSetInit: function(table) {
		this.loginInTableVariable = this.get("loginInTableVariable");
		this.tableId = table.getId();
		this.tableSet = VariableSetService.get(this.tableId);
	},
	enable: function() {
		if (this.target.type == "VARIABLE") {
			this.loginToFullName();
		} else if (this.target.type == "VARIABLESET") {
			var me = this;
			var logins = this.loginInTableVariable.getValue();
			PW.each(logins, function(sourceValue, currentRow) {
				if (sourceValue) {
					me.loginToFullName(sourceValue, currentRow);
				}
			});
		}
	},
	addToLock: function(variable) {
		this.lock = new Suncode.form.plugin.locking.Lock();
		this.lock.pushVariable(variable);
	},
	defaultActions: {
		variable: function(variable, newValue, oldValue) {
			this.loginToFullName(newValue);
		},
		variableSet: function(variableSet, added, updated, removed) {
			if (updated.length > 0) {
				for (updateIndex = 0; updateIndex < updated.length; updateIndex++) {
					var currentRow = updated[updateIndex].index;
					var sourceValue = VariableSetService.getValue(this.tableSet, currentRow, this.loginInTableVariable.getId())
					for (indexColumn = 0; indexColumn < updated[updateIndex].changes.length; indexColumn++) {
						if (this.loginInTableVariable.getId() == updated[updateIndex].changes[indexColumn]) {
							this.loginToFullName(sourceValue, currentRow);
						}
					}
				}
			}
		}
	},
	loginToFullName: function(sourceValue, currentRow) {
		if (!sourceValue) {
			sourceValue = this.sourceVar.getValue();
		}
		var targetVar = this.targetVar;
		var targetVarType = this.target.type;
		var failureMessage = this.failureMessage;
		this.addToLock(targetVar);
		var lock = this.lock;
		lock.lock();
		jQuery.ajax({
			type: "GET",
			data: {
				sourceValue: sourceValue
			},
			url: "plugin/com.suncode-cuf-components/user/usernames-to-fullnames/",
			error: function(jqXHR, textStatus, errorThrown) {
				Logger.error(errorThrown);
			},
			async: true
		})
			.done(function(data) {
				if (devMode) {
					Logger.debug("Action usernames-to-fullnames will now set variables...");
				}
				if (targetVarType == "VARIABLE") {
					targetVar.setValue(data);
				} else {
					targetVar.setItemValue(data, currentRow);
				}
			})
			.fail(function() {
				Logger.error("Request failed.");
				MessageService.showFailure(failureMessage);
			})
			.always(function() {
				lock.unlock();
			});
	}
});