PW.FormActions.create('table-get-records', {
    defaultActions: {
        button: function() {
            this.execute();
        },
        dtButton: function(button) {
			this.execute(button);
        },
    },

	execute: function(button) {
		var tableId = this.get('tableId');
		var variableSet;
		if (!tableId) {
			variableSet = button.getVariableSet();
		} else {			
			variableSet = VariableSetService.getVariableSet(tableId);
		}
		if (variableSet) {
			this.getRecords(variableSet.getVariables());
		} else {
			console.error('Invalid VariableSet id: ' + tableId);
			alert(CUFCommon.t('action.invoking-action-error-occured'));
		}
	},

    getRecords: function(variables) {
        var tableStoreVariable = this.getRaw('tableStore').value.value;
        var tableStore = TableStore.create(variables);
        tableStoreVariable.setValue(tableStore);
    }
});
