/**
 * Set value from servlet action implementation. 
 */
PW.FormActions.create('set-value-from-servlet', {
    
    defaultActions: {
        button: function(button){
            this.returnServlet();
        },
        variable: function(variable, newValue, oldValue){
            this.returnServlet();
        },
        variableSet: function(variableSet, added, updated, removed){
            this.returnServlet();
        }
    },
    
    returnServlet: function() {
        var servletName = this.get("servletPath");
        var variableToSet = this.get("variableToSet");
        var params = this.getServletParameters();
        jQuery.ajax({
            url : servletName,
            type : "GET",
            data : params,
            success : function( data, textStatus, jqXHR ) 
            {
            	if (devMode){
            		Logger.debug("Action set-value-from-servlet will now set variable...");
            	}
            	if (variableToSet.getType().is("date") || variableToSet.getType().is("datetime")){
            		variableToSet.setValue(new Date(data));
            	}
            	else{
            		variableToSet.setValue(data);
            	}
            },
            async: false,
            error : function(jqXHR, textStatus, errorThrown) {
                var messageService = ServiceFactory.getMessageService();
                messageService.showFailure(CUFCommon.t('action.error.get-data-from-servlet') + ' ' + errorThrown);
            }
        });
    },
    
    getServletParameters: function() {
        var params = {};
        var servletParametersNames = this.get("servletParametersNames");
        var servletParametersValues = this.get("servletParametersValues");
        if(servletParametersNames == null || servletParametersValues == null){
            return params;
        }
        PW.each(servletParametersNames, function (name, index) {
            params[name] = servletParametersValues[index];
        });
        return params;
    }
});