/**
 * Delete selected implementation
 */
PW.FormActions.create('paint-rows', {
    variableSetInit: function (table) {
        let conditionFn = this.get("condition");
        if (!conditionFn || conditionFn.getReturnType() !== PW.BooleanType) {
            Logger.error('Action paints-rows needs boolean function in condition parameter.');
            return;
        }
        this.columsID = [];
        let columns = this.get("columns");
        for (let index = 0; index < columns.length; index++) {
            this.columsID.push(columns[index].getId());
        }
        this.setContextVariable("currentRow", 0);
        this.table = table;
        this.conditionalRender();
    },

    enable: function () {
        this.isEnable = true;
        this.table.refresh();
        this.get("condition").on("change", function () {
            this.table.refresh();
        }, this);
    },

    disable: function () {
        this.isEnable = false;
        this.table.refresh();
        this.get("condition").off("change", function () {
            this.table.refresh();
        }, this);
    },

    paint: function (me, metaData, column) {
        if (metaData.row >= me.columnLength(column)) {
            return;
        }

        me.setContextVariable("currentRow", metaData.row);
        me.setContextVariable("columnId", column);
        if (!me.get("condition").call()) {
            return;
        }

        let cssColor = "";
        if (!this.get("useSystemThemeFontColor")) {
            let color = this.resolveColor(me.get("color"));
            cssColor = color ? 'color: ' + color : "";
        }

        let cssColorBG = "";
        if (!this.get("useSystemThemeBackgroundColor")) {
            let colorBG = this.resolveColor(me.get("colorBG"));
            cssColorBG = colorBG ? 'background-color: ' + colorBG : "";
        }

        metaData.style = cssColor + ";" + cssColorBG + ";";
    },

    resolveColor: function (color) {
        //kompatybilność wstecz
        if (color && (color.indexOf('#') < 0)) {
            color = "#" + color;
        }
        return color;
    },

    conditionalRender: function () {
        let me = this;
        VariableSetService.addRenderer(me.table.grid, function (value, data, column, metaData) {
            if (me.isEnable) {
                me.paint(me, metaData, column);
            }
        }, me.columsID);
    },

    columnLength: function (column) {
        let tableVariables = this.table.getVariables();
        for (let i = 0; i < tableVariables.length; i++) {
            if (tableVariables[i].id == column) {
                return tableVariables[i].getValue().length;
            }
        }
        return -1;
    }
});