polyfill_codePointAt();
window.CUFCommon.Hashids = {
    encode: function( numbers ) {
        var minLength = 0;
        var alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
        var seps = 'cfhistuCFHISTU';
        var sepsChars = Array.from(seps);
        var salt = '';
        var saltChars = Array.from(salt);
        var alphabetChars = Array.from(alphabet);
        var minAlphabetLength = 16;
        var sepDiv = 3.5;
        var guardDiv = 12;

        salt = saltChars;

        var uniqueAlphabet = alphabetChars;
        if (uniqueAlphabet.length < minAlphabetLength) {
            throw new Error("Hashids: alphabet must contain at least " + minAlphabetLength + " unique characters, provided: " + uniqueAlphabet);
        }

        alphabet = hashids_withoutChars(uniqueAlphabet, sepsChars);
        var filteredSeps = hashids_onlyChars(sepsChars, uniqueAlphabet);
        seps = hashids_shuffle(filteredSeps, saltChars);
        var sepsLength;
        var diff;

        if (seps.length === 0 || alphabet.length / seps.length > sepDiv) {
            sepsLength = Math.ceil(alphabet.length / sepDiv);

            if (sepsLength > seps.length) {
                var _this$seps;

                diff = sepsLength - seps.length;

                (_this$seps = seps).push.apply(_this$seps, hashids_toConsumableArray(alphabet.slice(0, diff)));

                alphabet = alphabet.slice(diff);
            }
        }

        alphabet = hashids_shuffle(alphabet, saltChars);
        var guardCount = Math.ceil(alphabet.length / guardDiv);

        var guards;
        if (alphabet.length < 3) {
            guards = seps.slice(0, guardCount);
            seps = seps.slice(guardCount);
        } else {
            guards = alphabet.slice(0, guardCount);
            alphabet = alphabet.slice(guardCount);
        }

        var numbersIdInt = numbers.reduce(function (last, number, i) {
            return last + (typeof number === 'bigint' ? Number(number % BigInt(i + 100)) : number % (i + 100));
        }, 0);
        var ret = [alphabet[numbersIdInt % alphabet.length]];
        var lottery = ret.slice();

        numbers.forEach(function (number, i) {
            var _ret;

            var buffer = lottery.concat(salt, alphabet);
            alphabet = hashids_shuffle(alphabet, buffer);
            var last = hashids_toAlphabet(number, alphabet);

            (_ret = ret).push.apply(_ret, hashids_toConsumableArray(last));

            if (i + 1 < numbers.length) {
                var charCode = last[0].codePointAt(0) + i;
                var extraNumber = typeof number === 'bigint' ? Number(number % BigInt(charCode)) : number % charCode;
                ret.push(seps[extraNumber % seps.length]);
            }
        });

        if (ret.length < minLength) {
            var prefixGuardIndex = (numbersIdInt + ret[0].codePointAt(0)) % guards.length;
            ret.unshift(guards[prefixGuardIndex]);

            if (ret.length < minLength) {
                var suffixGuardIndex = (numbersIdInt + ret[2].codePointAt(0)) % guards.length;
                ret.push(guards[suffixGuardIndex]);
            }
        }

        var halfLength = Math.floor(alphabet.length / 2);

        while (ret.length < minLength) {
            var _ret2, _ret3;

            alphabet = hashids_shuffle(alphabet, alphabet);

            (_ret2 = ret).unshift.apply(_ret2, hashids_toConsumableArray(alphabet.slice(halfLength)));

            (_ret3 = ret).push.apply(_ret3, hashids_toConsumableArray(alphabet.slice(0, halfLength)));

            var excess = ret.length - minLength;

            if (excess > 0) {
                var halfOfExcess = excess / 2;
                ret = ret.slice(halfOfExcess, halfOfExcess + minLength);
            }
        }

        return ret.join('');
    }
}

function hashids_toConsumableArray(arr) { return hashids_arrayWithoutHoles(arr) || hashids_iterableToArray(arr) || hashids_nonIterableSpread(); }

function hashids_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function hashids_iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function hashids_arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function hashids_shuffle(alphabetChars, saltChars) {
    if (saltChars.length === 0) {
        return alphabetChars;
    }

    var integer;
    var transformed = alphabetChars.slice();

    for (var i = transformed.length - 1, v = 0, p = 0; i > 0; i--, v++) {
        v %= saltChars.length;
        p += integer = saltChars[v].codePointAt(0);
        var j = (integer + v + p) % i;

        var a = transformed[i];
        var b = transformed[j];
        transformed[j] = a;
        transformed[i] = b;
    }

    return transformed;
}

function hashids_toAlphabet(input, alphabetChars) {
    var id = [];

    if (typeof input === 'bigint') {
        var alphabetLength = BigInt(alphabetChars.length);

        do {
            id.unshift(alphabetChars[Number(input % alphabetLength)]);
            input = input / alphabetLength;
        } while (input > BigInt(0));
    } else {
        do {
            id.unshift(alphabetChars[input % alphabetChars.length]);
            input = Math.floor(input / alphabetChars.length);
        } while (input > 0);
    }

    return id;
};

function hashids_withoutChars(chars, _withoutChars) {
    return chars.filter(function (char) {
        return _withoutChars.indexOf(char) < 0;
    });
};

function hashids_onlyChars(chars, keepChars) {
    return chars.filter(function (char) {
        return keepChars.indexOf(char) >= 0;
    });
};

function hashids_escapeRegExp(text) {
    return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
};

function polyfill_codePointAt() {
    if (!String.prototype.codePointAt) {
        (function() {
            'use strict'; // needed to support `apply`/`call` with `undefined`/`null`
            var defineProperty = (function() {
                // IE 8 only supports `Object.defineProperty` on DOM elements
                try {
                    var object = {};
                    var $defineProperty = Object.defineProperty;
                    var result = $defineProperty(object, object, object) && $defineProperty;
                } catch(error) {}
                return result;
            }());
            var codePointAt = function(position) {
                if (this == null) {
                    throw TypeError();
                }
                var string = String(this);
                var size = string.length;
                // `ToInteger`
                var index = position ? Number(position) : 0;
                if (index != index) { // better `isNaN`
                    index = 0;
                }
                // Account for out-of-bounds indices:
                if (index < 0 || index >= size) {
                    return undefined;
                }
                // Get the first code unit
                var first = string.charCodeAt(index);
                var second;
                if ( // check if it’s the start of a surrogate pair
                    first >= 0xD800 && first <= 0xDBFF && // high surrogate
                    size > index + 1 // there is a next code unit
                ) {
                    second = string.charCodeAt(index + 1);
                    if (second >= 0xDC00 && second <= 0xDFFF) { // low surrogate
                        // https://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
                        return (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
                    }
                }
                return first;
            };
            if (defineProperty) {
                defineProperty(String.prototype, 'codePointAt', {
                    'value': codePointAt,
                    'configurable': true,
                    'writable': true
                });
            } else {
                String.prototype.codePointAt = codePointAt;
            }
        }());
    }
}