PW.Functions.register("calculateDaysDifference", "integer", ["date", "date", "boolean"],
    function (firstDate, secondDate, includeFreeDays) {
        if (!firstDate || !secondDate) {
            return 0;
        }
        return callDateFunctionEndpoint(
            "calculateDaysDifference",
            {
                firstDate: formatDateForApi(firstDate, false),
                secondDate: formatDateForApi(secondDate, false),
                includeFreeDays: includeFreeDays
            },
            "json",
            null,
            0
        );
    }
);

PW.Functions.register("calculateTimeDifference", "integer", ["datetime", "datetime", "boolean", "boolean", "string"], 
    function (firstDateTime, secondDateTime, includeFreeDays, timeShift, returnType) {
        if (!firstDateTime || !secondDateTime) {
            return 0;
        }
        return callDateFunctionEndpoint(
            "calculateTimeDifference",
            {
                firstDate: formatDateForApi(firstDateTime, true),
                secondDate: formatDateForApi(secondDateTime, true),
                includeFreeDays: includeFreeDays,
                timeShift: timeShift,
                returnType: returnType
            },
            "json",
            null,
            0
        );
    }
);

PW.Functions.register("calcDateWorkingDays", "date", ["date", "integer"], 
    function(date, workingDays) {
        if (!date) {
            return null;
        }
        return callDateFunctionEndpoint(
            "calcDateWorkingDays",
            {
                date: formatDateForApi(date, false),
                workingDays: workingDays,
                isDateTime: false
            },
            "text",
            function(data) { return parseDateFromApi(data, false); },
            null
        );
    }
);

PW.Functions.register("calcDateWorkingDays", "datetime", ["datetime", "integer"], 
    function(dateTime, workingDays) {
        if (!dateTime) {
            return null;
        }
        return callDateFunctionEndpoint(
            "calcDateWorkingDays",
            {
                date: formatDateForApi(dateTime, true),
                workingDays: workingDays,
                isDateTime: true
            },
            "text",
            function(data) { return parseDateFromApi(data, true); },
            null
        );
    }
);

PW.Functions.register("nextWorkingDay", "date", ["date"], 
    function(date) {
        if (!date) {
            return null;
        }
        return callDateFunctionEndpoint(
            "nextWorkingDay",
            {
                date: formatDateForApi(date, false),
                isDateTime: false
            },
            "text",
            function(data) { return parseDateFromApi(data, false); },
            null
        );
    }
);

PW.Functions.register("nextWorkingDay", "datetime", ["datetime"], 
    function(date) {
        if (!date) {
            return null;
        }
        return callDateFunctionEndpoint(
            "nextWorkingDay",
            {
                date: formatDateForApi(date, true),
                isDateTime: true
            },
            "text",
            function(data) { return parseDateFromApi(data, true); },
            null
        );
    }
);

PW.Functions.register("previousWorkingDay", "date", ["date"], 
    function(date) {
        if (!date) {
            return null;
        }
        return callDateFunctionEndpoint(
            "previousWorkingDay",
            {
                date: formatDateForApi(date, false),
                isDateTime: false
            },
            "text",
            function(data) { return parseDateFromApi(data, false); },
            null
        );
    }
);

PW.Functions.register("previousWorkingDay", "datetime", ["datetime"], 
    function(date) {
        if (!date) {
            return null;
        }
        return callDateFunctionEndpoint(
            "previousWorkingDay",
            {
                date: formatDateForApi(date, true),
                isDateTime: true
            },
            "text",
            function(data) { return parseDateFromApi(data, true); },
            null
        );
    }
);

function callDateFunctionEndpoint(endpoint, params, dataType, parseResponse, defaultValue) {
    let result = null;
    jQuery.ajax({
        url: "plugin/com.suncode-cuf-components/dateFunctions/" + endpoint,
        type: "GET",
        data: params,
        dataType: dataType,
        async: false,
        success: function (data) {
            result = parseResponse ? parseResponse(data) : data;
        },
        error: function (error) {
            Logger.error("Date function error [" + endpoint + "]: ", error);
            result = defaultValue;
        }
    });
    return result;
}

function formatDateForApi(date, isDateTime) {
    return Ext4.Date.format(date, isDateTime ? "Y-m-d\\TH:i:s" : "Y-m-d");
}

function parseDateFromApi(dateString, isDateTime) {
    return Ext4.Date.parse(dateString, isDateTime ? "Y-m-d\\TH:i:s" : "Y-m-d");
}