/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.substitutes;

import com.suncode.cuf.common.user.substitutes.SubstitutedUsersDataFinder;
import com.suncode.cuf.common.user.substitutes.model.SubstitutedUsersData;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubstitutedDataGetter {
    @Autowired
    SubstitutedUsersDataFinder finder;

    public SubstitutedUsersData getData(String substituteUsername) {
        return this.getDataInternal(substituteUsername, false);
    }

    public SubstitutedUsersData getData(String substituteUsername, boolean deep) {
        return this.getDataInternal(substituteUsername, deep);
    }

    private SubstitutedUsersData getDataInternal(String username, boolean deep) {
        List<User> foundUsers = this.finder.findSubstitutedUsers(username, deep);
        if (foundUsers.isEmpty()) {
            foundUsers.add(this.finder.getSingleUserData(username));
        }
        return this.getUserData(foundUsers);
    }

    private SubstitutedUsersData getUserData(List<User> foundUsers) {
        SubstitutedUsersData data = new SubstitutedUsersData();
        StringBuilder usernames = new StringBuilder();
        StringBuilder emails = new StringBuilder();
        StringBuilder positions = new StringBuilder();
        StringBuilder superiors = new StringBuilder();
        for (User user : foundUsers) {
            this.addUsernames(usernames, user);
            this.addEmails(emails, user);
            this.addPositionsAndSuperiors(positions, superiors, user);
        }
        data.setUsernames(usernames.substring(0, usernames.length() - 1));
        data.setEmails(emails.substring(0, emails.length() - 1));
        if (positions.length() > 0) {
            data.setPositions(positions.substring(0, positions.length() - 1));
        }
        if (superiors.length() > 0) {
            data.setSuperiors(superiors.substring(0, superiors.length() - 1));
        }
        return data;
    }

    private void addUsernames(StringBuilder usernamesBuilder, User user) {
        usernamesBuilder.append(user.getUserName()).append(";");
    }

    private void addEmails(StringBuilder emailsBuilder, User user) {
        emailsBuilder.append(user.getEmail()).append(";");
    }

    private void addPositionsAndSuperiors(StringBuilder positionsBuilder, StringBuilder superiorsBuilder, User user) {
        Set positions = user.getPositions();
        for (Position position : positions) {
            positionsBuilder.append(position.getSymbol()).append(";");
            Position higherPosition = position.getHigherPosition();
            if (higherPosition == null || higherPosition.getUser() == null) continue;
            superiorsBuilder.append(higherPosition.getUser().getUserName()).append(";");
        }
    }
}

