/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.substitution.Substitution;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="scripts/dynamic-pwe/add-substitution-app-form.js")
public class AddSubstitutionApp {
    @Autowired
    private RoleService roleService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private SubstitutionService substitutionService;
    @Autowired
    private UserService userService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("add-substitution-app")).name("application.add-substitution.name")).description("application.add-substitution.desc")).category(new Category[]{Categories.USER})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}add-substitution-application")).icon((Icon)SilkIconPack.GROUP)).parameter().id("substitutedLogin").name("application.add-substitution.substitutedLogin.name").type((Type)Types.STRING).create()).parameter().id("substituteLogin").name("application.add-substitution.substituteLogin.name").type((Type)Types.STRING).create()).parameter().id("dateFrom").name("application.add-substitution.dateFrom.name").type((Type)Types.DATE).create()).parameter().id("dateTo").name("application.add-substitution.dateTo.name").type((Type)Types.DATE).create()).parameter().id("substitutionType").name("application.add-substitution.substitutionType.name").type((Type)Types.STRING).optional().create()).parameter().id("processDefId").name("application.add-substitution.processName.name").type((Type)Types.STRING).optional().create()).parameter().id("roleId").name("application.add-substitution.roleName.name").type((Type)Types.STRING).optional().create();
    }

    public void execute(@Param String substitutedLogin, @Param String substituteLogin, @Param LocalDate dateFrom, @Param LocalDate dateTo, @Param String processDefId, @Param String roleId) {
        Substitution substitution = new Substitution();
        substitution.setSubstituted(this.userService.getUser(substitutedLogin, new String[0]));
        substitution.setSubstitute(this.userService.getUser(substituteLogin, new String[0]));
        this.setDate(dateFrom, arg_0 -> ((Substitution)substitution).setStartDate(arg_0));
        this.setDate(dateTo, arg_0 -> ((Substitution)substitution).setFinishDate(arg_0));
        if (StringUtils.isNotBlank((CharSequence)processDefId)) {
            ProcessDefinition processDefinition = this.processService.getProcessDefinition(processDefId);
            Assert.notNull((Object)processDefinition, (String)("Process [" + processDefId + "] does not exist."));
            substitution.setProcessDefId(processDefId);
            if (roleId != null) {
                Role role = this.roleService.getRole(processDefinition.getPackageId(), processDefinition.getProcessDefinitionId(), roleId);
                Assert.notNull((Object)role, (String)("Role [" + roleId + "] does not exist."));
                substitution.setRole(role);
            }
        }
        this.substitutionService.createSubstitution(substitution);
    }

    private void setDate(LocalDate date, Consumer<LocalDateTime> dateSetter) {
        if (date != null) {
            dateSetter.accept(date.toLocalDateTime(LocalTime.MIDNIGHT));
        }
    }
}

