/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.scheduledtasks.servlets;

import com.plusmpm.database.scheduledTasks.ScheduledTasksMethods;
import com.suncode.cuf.common.scheduledtasks.services.ScheduledTaskService;
import com.suncode.pwfl.search.CountedResult;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scheduled-tasks"})
public class ScheduledTasksController {
    @Autowired
    private ScheduledTaskService scheduledTaskService;

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    public CountedResult<Map<String, String>> getAll(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List allScheduledTasks = ScheduledTasksMethods.getAllScheduledTasks();
        List<Map> scheduledTaskNames = allScheduledTasks.stream().map(task -> Map.of("name", task.getName(), "displayValue", String.format("[%d] %s", task.getId(), task.getName()))).filter(task -> query == null || query.isEmpty() || ((String)task.get("displayValue")).toLowerCase().contains(query.toLowerCase())).sorted(Comparator.comparing(task -> (String)task.get("displayValue"), String.CASE_INSENSITIVE_ORDER)).toList();
        int totalCount = scheduledTaskNames.size();
        int fromIndex = Math.min(start, scheduledTaskNames.size());
        int toIndex = Math.min(start + limit, scheduledTaskNames.size());
        List<Map> paginatedList = scheduledTaskNames.subList(fromIndex, toIndex);
        return new CountedResult((long)totalCount, paginatedList);
    }

    @RequestMapping(value={"/run"}, method={RequestMethod.POST})
    public ResponseEntity<String> run(@RequestParam(value="taskName") String taskName) {
        try {
            ScheduledTaskService.ScheduledTaskExecutionResult result = this.scheduledTaskService.executeScheduledTask(taskName);
            if ("ok".equals(result.getStatus())) {
                return new ResponseEntity((Object)result.getResponse(), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)result.getResponse(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

