/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.scheduledtasks.services;

import com.plusmpm.database.scheduledTasks.ScheduledTasksMethods;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskHistoryInfo;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskInfoService;
import com.suncode.pwfl.administration.scheduledtask.info.execution.ScheduledTaskExecution;
import com.suncode.pwfl.administration.scheduledtask.info.execution.ScheduledTaskState;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduledTaskService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskService.class);
    @Autowired
    private ScheduledTaskInfoService scheduledTaskInfoService;

    public ScheduledTaskExecutionResult executeScheduledTask(String taskName) {
        log.debug("Executing scheduled task: {}", (Object)taskName);
        List allScheduledTasks = ScheduledTasksMethods.getAllScheduledTasks();
        Optional<Long> scheduledTaskId = allScheduledTasks.stream().filter(task -> task.getName().equals(taskName)).map(task -> task.getId()).findFirst();
        if (!scheduledTaskId.isPresent()) {
            throw new IllegalArgumentException("Scheduled task not found: " + taskName);
        }
        ScheduledTaskExecution scheduledTaskExecution = this.scheduledTaskInfoService.executeTaskManually(scheduledTaskId.get().longValue());
        scheduledTaskExecution.awaitTaskCompleted(Duration.ofSeconds(999999L));
        if (scheduledTaskExecution.getState() == ScheduledTaskState.DONE) {
            Pagination startDate = Pagination.create((Sorter)new Sorter("startDate", SortDirection.DESC), (Integer)0, (Integer)1);
            List historyEntriesInfo = this.scheduledTaskInfoService.getHistoryEntriesInfo(scheduledTaskId.get(), startDate);
            if (!historyEntriesInfo.isEmpty()) {
                ScheduledTaskHistoryInfo historyEntry = (ScheduledTaskHistoryInfo)historyEntriesInfo.get(0);
                if (historyEntry.getSuccess().booleanValue()) {
                    log.debug("Scheduled task '{}' executed successfully", (Object)taskName);
                    return new ScheduledTaskExecutionResult(historyEntry.getResult(), "ok");
                }
                log.warn("Scheduled task '{}' execution failed: {}", (Object)taskName, (Object)historyEntry.getResult());
                return new ScheduledTaskExecutionResult(historyEntry.getResult(), "error");
            }
            log.warn("No history found for scheduled task: {}", (Object)taskName);
            return new ScheduledTaskExecutionResult("No execution history available", "error");
        }
        log.warn("Scheduled task '{}' did not complete. State: {}", (Object)taskName, (Object)scheduledTaskExecution.getState());
        return new ScheduledTaskExecutionResult("The task has not been completed", "error");
    }

    public static class ScheduledTaskExecutionResult {
        private final String response;
        private final String status;

        public ScheduledTaskExecutionResult(String response, String status) {
            this.response = response;
            this.status = status;
        }

        public String getResponse() {
            return this.response;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

