/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.validators;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.general.ProcessService;
import com.suncode.cuf.common.general.servlets.DuplicateCheckConfig;
import com.suncode.cuf.common.utils.AlertInterpreter;
import com.suncode.cuf.common.utils.CommonUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.annotation.ValidatorsScript;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
@ValidatorsScript(value="scripts/validators-callbacks/validate-uniqueness-callback.js")
@ComponentsFormScript(value="scripts/dynamic-pwe/validate-uniqueness-form.js")
public class ValidateUniqueness {
    private static final Logger log = LoggerFactory.getLogger(ValidateUniqueness.class);
    @Autowired
    private ProcessService cufProcessService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("processdoc-uniqueness-validator")).name("validator.processdoc.uniqueness.name")).description("validator.processdoc.uniqueness.desc")).category(new Category[]{Categories.GENERAL})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}process-uniqueness-validation")).icon((Icon)SilkIconPack.PACKAGE)).parameter().id("variables").name("validator.processdoc.uniqueness.variables_param_name").description("validator.processdoc.uniqueness.variables_param_desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("discriminatingVariables").name("validator.processdoc.uniqueness.discriminating_param.name").description("validator.processdoc.uniqueness.discriminating_param.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("discriminatingValues").name("validator.processdoc.uniqueness.discriminatingVals_param.name").description("validator.processdoc.uniqueness.discriminatingVals_param.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("confirmation").name("validator.confirm_param.name_default").description("validator.confirm_param.desc_default").type((Type)Types.BOOLEAN).create()).parameter().id("alert").name("validator.alert_param.name_default").description("validator.alert_param.desc_default").type((Type)Types.STRING).optional().create()).parameter().id("processesType").name("validator.processdoc.uniqueness.processesType.name").description("validator.processdoc.uniqueness.processesType.desc").type((Type)Types.STRING).defaultValue((Object)"ALL").create()).parameter().id("caseSensitive").name("validator.processdoc.uniqueness.caseSensitive.name").description("validator.processdoc.uniqueness.caseSensitive.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create();
    }

    public void validate(@Param Variable[] variables, @Param Variable[] discriminatingVariables, @Param String[] discriminatingValues, @Param boolean confirmation, @Param String alert, @Param String processesType, @Param boolean caseSensitive, ValidationContext validationContext, ValidationErrors errors, Translator translator) {
        try {
            DuplicateCheckConfig duplicateCheckConfig = DuplicateCheckConfig.builder().variablesToCheck(CommonUtils.convertVariableArrayToVariableDtoArray(variables)).message(alert).variablesExcludingDuplicates(CommonUtils.getExcludingVariables(discriminatingVariables, discriminatingValues)).processesType(processesType).caseSensitive(caseSensitive).processDefId(validationContext.getProcessDefId()).processId(validationContext.getProcessId()).build();
            if (!this.cufProcessService.hasDuplicateValues(duplicateCheckConfig)) {
                return;
            }
            List<Process> duplicatesByProcessState = this.cufProcessService.getProcessDuplicates(duplicateCheckConfig);
            if (duplicatesByProcessState.isEmpty()) {
                return;
            }
            AtomicInteger counter = new AtomicInteger(1);
            duplicatesByProcessState.forEach(process -> log.info("Znaleziony duplikat #{}: {}", (Object)counter.getAndIncrement(), (Object)process.getProcessId()));
            Map<String, Object> context = this.cufProcessService.getProcessContext(duplicatesByProcessState.get(0).getProcessId());
            String msg = AlertInterpreter.getInterpreted(alert, context);
            this.handleResult(confirmation, errors, msg, translator);
        }
        catch (Exception e) {
            errors.add(e.getMessage());
        }
    }

    private void handleResult(boolean confirmation, ValidationErrors errors, String alert, Translator translator) {
        if (confirmation) {
            errors.addConfirmation(alert, translator.getMessage("validator.title_default"));
            log.debug("Wy\u015bwietlono komunikat potwierdzenia.");
        } else {
            errors.add(alert);
        }
    }
}

