/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.validators;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.general.ProcessService;
import com.suncode.cuf.common.general.schemas.AddDuplicateValidatorWindow;
import com.suncode.cuf.common.general.servlets.DuplicateCheckConfig;
import com.suncode.cuf.common.utils.CommonUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.annotation.ValidatorsScript;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
@ValidatorsScript(value="scripts/validators-callbacks/validate-duplicates-callback.js")
@ComponentsFormScript(value="scripts/dynamic-pwe/validate-duplicates-form.js")
public class ValidateDuplicates {
    private static final Logger log = LoggerFactory.getLogger(ValidateDuplicates.class);
    private static final int MAX_DUPLICATES_TO_DISPLAY = 100;
    @Autowired
    private ProcessService cufProcessService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("find-duplicates-validator")).name("validator.duplicates.name")).description("validator.duplicates.desc")).category(new Category[]{Categories.GENERAL})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}duplicate-validation-vadlidator")).icon((Icon)SilkIconPack.APPLICATION_FORM_MAGNIFY)).parameter().id("variablesToCheck").name("validator.duplicates.variablesToCheck.name").description("validator.duplicates.variablesToCheck.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("variablesExcludingDuplicates").name("validator.duplicates.variablesExcludingDuplicates.name").description("validator.duplicates.variablesExcludingDuplicates.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("valuesExcludingDuplicates").name("action.find-duplicates-action.valuesExcludingDuplicates.name").description("action.find-duplicates-action.valuesExcludingDuplicates.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("confirmation").name("validator.duplicates.confirmation.name").description("validator.duplicates.confirmation.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("dataVariables").name("action.find-duplicates-action.dataVariables.name").description("action.find-duplicates-action.dataVariables.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("message").name("validator.duplicates.message.name").description("validator.duplicates.message.desc").type((Type)Types.STRING).optional().create()).parameter().id("caseSensitive").name("validator.duplicates.caseSensitive.name").description("validator.duplicates.caseSensitive.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("processesType").name("validator.duplicates.processesType.name").description("validator.duplicates.processesType.desc").type((Type)Types.STRING).create()).parameter().id("duplicatePresentationComboBox").name("action.find-duplicates-action.duplicatePresentationComboBox.name").description("action.find-duplicates-action.duplicatePresentationComboBox.desc").type((Type)Types.STRING).defaultValue((Object)"BASIC").create()).parameter().id("saveDataToVariables").name("action.find-duplicates-action.saveDataToVariables.name").description("action.find-duplicates-action.saveDataToVariables.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)Boolean.FALSE).create()).parameter().id("setDataButtonName").name("action.find-duplicates-action.setDataButtonName.name").description("action.find-duplicates-action.setDataButtonName.desc").type((Type)Types.STRING).optional().create()).parameter().id("variablesToGetData").name("action.find-duplicates-action.variablesToGetData.name").description("action.find-duplicates-action.variablesToGetData.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("variablesToSetData").name("action.find-duplicates-action.variablesToSetData.name").description("action.find-duplicates-action.variablesToSetData.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("isHiddenColumn").name("action.find-duplicates-action.isHiddenColumn.name").description("action.find-duplicates-action.isHiddenColumn.desc").type((Type)Types.BOOLEAN_ARRAY).optional().create()).parameter().id("addColumnWithProcessName").name("action.find-duplicates-action.addColumnWithProcessName.name").description("action.find-duplicates-action.addColumnWithProcessName.desc").optional().type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("addLinkToDocuments").name("validator.duplicates.addLinkToDocuments.name").description("validator.duplicates.addLinkToDocuments.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).optional().create()).parameter().id("addLinkToProcess").name("validator.duplicates.addLinkToProcess.name").description("validator.duplicates.addLinkToProcess.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("allowAcceptanceDespiteDuplicates").name("validator.duplicates.allowAcceptanceDespiteDuplicates.name").description("validator.duplicates.allowAcceptanceDespiteDuplicates.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("customContinueButtonText").name("validator.duplicates.customContinueButtonText.name").description("validator.duplicates.customContinueButtonText.desc").type((Type)Types.STRING).optional().create()).parameter().id("customAcceptanceButtonText").name("validator.duplicates.customAcceptanceButtonText.name").description("validator.duplicates.customAcceptanceButtonText.desc").type((Type)Types.STRING).optional().create();
    }

    public void validate(Parameters parameters, ValidationContext validationContext, ValidationErrors errors) {
        try {
            DuplicateCheckConfig duplicateCheckConfig = DuplicateCheckConfig.builder().variablesToCheck(CommonUtils.convertVariableArrayToVariableDtoArray((Variable[])parameters.get("variablesToCheck"))).message((String)parameters.get("message")).variablesExcludingDuplicates(CommonUtils.getExcludingVariables((Variable[])parameters.get("variablesExcludingDuplicates"), (String[])parameters.get("valuesExcludingDuplicates"))).processesType((String)parameters.get("processesType")).caseSensitive((Boolean)parameters.get("caseSensitive")).processDefId(validationContext.getProcessDefId()).processId(validationContext.getProcessId()).build();
            if (!this.cufProcessService.hasDuplicateValues(duplicateCheckConfig)) {
                return;
            }
            if (((Boolean)parameters.get("confirmation")).booleanValue()) {
                CountedResult<String> duplicatesResult = this.cufProcessService.getProcessDuplicatesIds(duplicateCheckConfig, 100);
                List processIdsByProcessState = duplicatesResult.getData();
                if (processIdsByProcessState.isEmpty()) {
                    return;
                }
                String[] linksToProcesses = (String[])processIdsByProcessState.stream().map(this.cufProcessService::getLinkToProcess).toArray(String[]::new);
                AddDuplicateValidatorWindow params = AddDuplicateValidatorWindow.builder().variablesToCheck((Variable[])parameters.get("variablesToCheck")).variablesExcludingDuplicates((Variable[])parameters.get("variablesExcludingDuplicates")).processesType((String)parameters.get("processesType")).data(processIdsByProcessState).message((String)parameters.get("message")).dataVariables((Variable[])parameters.get("dataVariables")).valuesExcludingDuplicates((String[])parameters.get("valuesExcludingDuplicates")).caseSensitive(duplicateCheckConfig.getCaseSensitive()).duplicatePresentationComboBox((String)parameters.get("duplicatePresentationComboBox")).saveDataToVariables((Boolean)parameters.get("saveDataToVariables")).setDataButtonName((String)parameters.get("setDataButtonName")).variablesToGetData((Variable[])parameters.get("variablesToGetData")).variablesToSetData((Variable[])parameters.get("variablesToSetData")).addColumnWithProcessName((Boolean)parameters.get("addColumnWithProcessName")).isHiddenColumn((Boolean[])parameters.get("isHiddenColumn")).linksToProcesses(linksToProcesses).addLinkToDocuments((Boolean)parameters.get("addLinkToDocuments")).addLinkToProcess((Boolean)parameters.get("addLinkToProcess")).allowAcceptanceDespiteDuplicates((Boolean)parameters.get("allowAcceptanceDespiteDuplicates")).customContinueButtonText((String)parameters.get("customContinueButtonText")).customAcceptanceButtonText((String)parameters.get("customAcceptanceButtonText")).duplicatesTotalCount(duplicatesResult.getTotal()).build();
                errors.invokeCallback((Object)params);
            } else {
                errors.add(duplicateCheckConfig.getMessage());
            }
        }
        catch (Exception e) {
            errors.add(e.getMessage());
        }
    }
}

