/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.service;

import com.suncode.cuf.common.general.service.DateFunctionsService;
import com.suncode.pwfl.util.date.FreeDayService;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DateFunctionsServiceImpl
implements DateFunctionsService {
    @Autowired
    private FreeDayService freeDayService;

    @Override
    public int calculateDaysDifference(LocalDate firstDate, LocalDate secondDate, Boolean includeFreeDays) {
        if (firstDate == null || secondDate == null) {
            return 0;
        }
        LocalDate earlierDate = this.getEarlierDate(firstDate, secondDate);
        LocalDate laterDate = this.getLaterDate(firstDate, secondDate);
        int dayDifference = 0;
        int absoluteDayDifference = (int)((laterDate.toDate().getTime() - earlierDate.toDate().getTime()) / 86400000L);
        if (Boolean.FALSE.equals(includeFreeDays)) {
            for (int i = 0; i <= absoluteDayDifference; ++i) {
                LocalDate dayInCheck = earlierDate.plusDays(i);
                if (this.isHolidayOrWeekend(dayInCheck)) continue;
                ++dayDifference;
            }
        } else {
            dayDifference = absoluteDayDifference + 1;
        }
        return dayDifference;
    }

    @Override
    public int calculateTimeDifference(LocalDateTime firstDate, LocalDateTime secondDate, Boolean includeFreeDays, Boolean timeShift, String returnType) {
        if (firstDate == null || secondDate == null) {
            return 0;
        }
        LocalDateTime earlierDateTime = this.getEarlierDateTime(firstDate, secondDate);
        LocalDateTime laterDateTime = this.getLaterDateTime(firstDate, secondDate);
        long differenceDay = Math.round((double)(laterDateTime.toDateTime().getMillis() - earlierDateTime.toDateTime().getMillis()) / 8.64E7);
        long nonWorkingDays = 0L;
        Boolean firstDayOff = false;
        Boolean lastDayOff = false;
        if (Boolean.FALSE.equals(includeFreeDays)) {
            int i = 0;
            while ((long)i <= differenceDay) {
                LocalDateTime dayInCheck = earlierDateTime.plusDays(i);
                if (this.isHolidayOrWeekend(dayInCheck.toLocalDate())) {
                    if (i == 0) {
                        firstDayOff = true;
                    } else if ((long)i == differenceDay) {
                        lastDayOff = true;
                    } else {
                        ++nonWorkingDays;
                    }
                }
                ++i;
            }
        }
        long millis = laterDateTime.toDateTime().getMillis() - this.calcNonWorkingTime(nonWorkingDays, earlierDateTime, laterDateTime, firstDayOff, lastDayOff);
        LocalDateTime tempDate = new LocalDateTime(millis);
        long durationMillis = tempDate.toDateTime().getMillis() - earlierDateTime.toDateTime().getMillis();
        if (!timeShift.booleanValue() || !includeFreeDays.booleanValue()) {
            DateTimeZone tz = DateTimeZone.getDefault();
            int tempDateOffset = tz.getOffset(laterDateTime.toDateTime().getMillis());
            int earlierDateTimeOffset = tz.getOffset(earlierDateTime.toDateTime().getMillis());
            durationMillis += (long)(tempDateOffset - earlierDateTimeOffset);
        }
        if (durationMillis < 0L) {
            return 0;
        }
        int yearDifference = tempDate.getYear() - earlierDateTime.getYear();
        switch (returnType) {
            case "SECOND": {
                return (int)(durationMillis / 1000L);
            }
            case "MINUTE": {
                return (int)(durationMillis / 60000L);
            }
            case "HOUR": {
                return (int)(durationMillis / 3600000L);
            }
            case "DAY": {
                return (int)(durationMillis / 86400000L);
            }
            case "WEEK": {
                return (int)(durationMillis / 604800000L);
            }
            case "MONTH": {
                int monthDifference = tempDate.getMonthOfYear() - earlierDateTime.getMonthOfYear();
                return yearDifference * 12 + monthDifference + this.getMonthCorrection(laterDateTime, earlierDateTime);
            }
            case "YEAR": {
                return yearDifference + this.getYearCorrection(laterDateTime, earlierDateTime);
            }
        }
        return 0;
    }

    @Override
    public LocalDate calcDateWorkingDays(LocalDate date, int workingDays) {
        boolean subtractionDaysFromDate;
        if (workingDays == 0) {
            return date;
        }
        boolean bl = subtractionDaysFromDate = workingDays < 0;
        if (!subtractionDaysFromDate) {
            if (this.isHolidayOrWeekend(date)) {
                date = this.setDateAtFirstWorkingDay(date);
            }
            int nextDay = 1;
            int totalWorkingDays = workingDays;
            int holidaysAndWorkingDays = workingDays;
            while (totalWorkingDays > 0) {
                LocalDate checkDayInDate = date.plusDays(nextDay);
                if (this.isHolidayOrWeekend(checkDayInDate)) {
                    ++holidaysAndWorkingDays;
                    ++nextDay;
                    continue;
                }
                --totalWorkingDays;
                ++nextDay;
            }
            return date.withFieldAdded(DurationFieldType.days(), holidaysAndWorkingDays);
        }
        if (this.isHolidayOrWeekend(date)) {
            date = this.setDateAtFirstPastWorkingDay(date);
        }
        int nextDay = -1;
        int totalWorkingDays = workingDays;
        int holidaysAndWorkingDays = workingDays;
        while (totalWorkingDays < 0) {
            LocalDate checkDayInDate = date.plusDays(nextDay);
            if (this.isHolidayOrWeekend(checkDayInDate)) {
                --holidaysAndWorkingDays;
                --nextDay;
                continue;
            }
            ++totalWorkingDays;
            --nextDay;
        }
        return date.withFieldAdded(DurationFieldType.days(), holidaysAndWorkingDays);
    }

    @Override
    public LocalDateTime calcDateWorkingDays(LocalDateTime dateTime, int workingDays) {
        if (workingDays == 0) {
            return dateTime;
        }
        LocalDate localDate = this.calcDateWorkingDays(dateTime.toLocalDate(), workingDays);
        return localDate.toLocalDateTime(dateTime.toLocalTime());
    }

    @Override
    public LocalDate nextWorkingDay(LocalDate date) {
        LocalDate startingDate = date.plusDays(1);
        return this.setDateAtFirstWorkingDay(startingDate);
    }

    @Override
    public LocalDateTime nextWorkingDay(LocalDateTime dateTime) {
        LocalDate localDate = this.nextWorkingDay(dateTime.toLocalDate());
        return localDate.toLocalDateTime(dateTime.toLocalTime());
    }

    @Override
    public LocalDate previousWorkingDay(LocalDate date) {
        LocalDate startingDate = date.minusDays(1);
        return this.setDateAtFirstPastWorkingDay(startingDate);
    }

    @Override
    public LocalDateTime previousWorkingDay(LocalDateTime dateTime) {
        LocalDate localDate = this.previousWorkingDay(dateTime.toLocalDate());
        return localDate.toLocalDateTime(dateTime.toLocalTime());
    }

    private LocalDate setDateAtFirstWorkingDay(LocalDate date) {
        int i = 0;
        LocalDate checkDayInDate = date;
        while (this.isHolidayOrWeekend(checkDayInDate)) {
            checkDayInDate = date.plusDays(++i);
        }
        return checkDayInDate;
    }

    private LocalDate setDateAtFirstPastWorkingDay(LocalDate date) {
        int i = 0;
        LocalDate checkDayInDate = date;
        while (this.isHolidayOrWeekend(checkDayInDate)) {
            checkDayInDate = date.plusDays(--i);
        }
        return checkDayInDate;
    }

    private long calcNonWorkingTime(long nonWorkingDays, LocalDateTime earlierDate, LocalDateTime laterDate, Boolean firstDayOff, Boolean lastDayOff) {
        long nonWorkingTime = nonWorkingDays * 86400000L;
        if (firstDayOff.booleanValue()) {
            nonWorkingTime += (long)(86400000 - this.milsOfTime(earlierDate));
        }
        if (lastDayOff.booleanValue()) {
            nonWorkingTime += (long)this.milsOfTime(laterDate);
        }
        return nonWorkingTime;
    }

    private int getYearCorrection(LocalDateTime laterDate, LocalDateTime earlierDate) {
        if (laterDate.getMonthOfYear() == earlierDate.getMonthOfYear()) {
            return this.getMonthCorrection(laterDate, earlierDate);
        }
        if (laterDate.getMonthOfYear() > earlierDate.getMonthOfYear()) {
            return 0;
        }
        return -1;
    }

    private int getMonthCorrection(LocalDateTime laterDate, LocalDateTime earlierDate) {
        if (laterDate.getDayOfMonth() == earlierDate.getDayOfMonth()) {
            return this.getTimeCorrection(laterDate, earlierDate);
        }
        if (laterDate.getDayOfMonth() > earlierDate.getDayOfMonth()) {
            return 0;
        }
        return -1;
    }

    private int getTimeCorrection(LocalDateTime laterDate, LocalDateTime earlierDate) {
        return this.milsOfTime(laterDate) < this.milsOfTime(earlierDate) ? -1 : 0;
    }

    private int milsOfTime(LocalDateTime date) {
        return date.getHourOfDay() * 3600000 + date.getMinuteOfHour() * 60000 + date.getSecondOfMinute() * 1000;
    }

    private LocalDate getEarlierDate(LocalDate firstDate, LocalDate secondDate) {
        if (firstDate.isBefore((ReadablePartial)secondDate)) {
            return firstDate;
        }
        return secondDate;
    }

    private LocalDateTime getEarlierDateTime(LocalDateTime firstDateTime, LocalDateTime secondDateTime) {
        if (firstDateTime.isBefore((ReadablePartial)secondDateTime)) {
            return firstDateTime;
        }
        return secondDateTime;
    }

    private LocalDate getLaterDate(LocalDate firstDate, LocalDate secondDate) {
        if (firstDate.isAfter((ReadablePartial)secondDate)) {
            return firstDate;
        }
        return secondDate;
    }

    private LocalDateTime getLaterDateTime(LocalDateTime firstDateTime, LocalDateTime secondDateTime) {
        if (firstDateTime.isAfter((ReadablePartial)secondDateTime)) {
            return firstDateTime;
        }
        return secondDateTime;
    }

    private boolean isHolidayOrWeekend(LocalDate date) {
        return this.freeDayService.isFreeDay(date.toDateTimeAtStartOfDay().getMillis());
    }
}

