/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.functions;

import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Functions
@FunctionsScript(value="functions/pdf-utils-functions.js")
public class PDFUtilsFunctions {
    private static final Logger log = LoggerFactory.getLogger(PDFUtilsFunctions.class);
    @Autowired
    private FileService fileService;

    @Function(value="PDFUtils.PDF2TXT")
    public String PDF2TXT(Integer fileId) {
        try {
            return this.extractTextFromPDF(fileId);
        }
        catch (Exception e) {
            log.error("Error while extracting text from PDF file {}: {}", new Object[]{fileId, e.getMessage(), e});
            return "";
        }
    }

    @Function(value="PDFUtils.isTextPDF")
    public Boolean isTextPDF(Integer fileId) {
        try {
            String text = this.extractTextFromPDF(fileId);
            return !text.trim().isEmpty();
        }
        catch (Exception e) {
            log.error("Error while checking PDF file {}: {}", new Object[]{fileId, e.getMessage(), e});
            return false;
        }
    }

    private String extractTextFromPDF(Integer fileId) throws Exception {
        Assert.notNull((Object)fileId, (String)"File ID cannot be null");
        try (InputStream inputStream = this.fileService.getFileInputStream(Long.valueOf(fileId.longValue()));){
            String string;
            block16: {
                PDDocument document;
                block14: {
                    String string2;
                    block15: {
                        document = PDDocument.load((InputStream)inputStream);
                        try {
                            if (document.getNumberOfPages() != 0) break block14;
                            log.debug("PDF file {} has no pages", (Object)fileId);
                            string2 = "";
                            if (document == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (document != null) {
                                try {
                                    document.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        document.close();
                    }
                    return string2;
                }
                PDFTextStripper textStripper = new PDFTextStripper();
                string = textStripper.getText(document);
                if (document == null) break block16;
                document.close();
            }
            return string;
        }
    }
}

