/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.utils.builders;

import com.suncode.cuf.common.db.utils.MainDBInfo;
import com.suncode.cuf.common.db.utils.builders.MSSQLIndexFiltersBuilder;
import com.suncode.cuf.common.db.utils.builders.OracleIndexFiltersBuilder;
import com.suncode.cuf.common.db.utils.builders.PostgreSQLIndexFiltersBuilder;
import com.suncode.cuf.common.general.VariableDto;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.SimpleFilter;
import com.suncode.pwfl.workflow.process.search.IndexFilter;
import com.suncode.pwfl.workflow.process.search.SimpleIndexFilter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexFiltersBuilder {
    private static final Logger log = LoggerFactory.getLogger(IndexFiltersBuilder.class);
    protected List<IndexFilter> filters;

    IndexFiltersBuilder() {
        this.setFilters(new ArrayList<IndexFilter>());
    }

    public static IndexFiltersBuilder getProperIndexFiltersBuilder() {
        MainDBInfo.DBType dbType = MainDBInfo.getMainDBType();
        switch (dbType) {
            case MSSQL: {
                return new MSSQLIndexFiltersBuilder();
            }
            case ORACLE: {
                return new OracleIndexFiltersBuilder();
            }
            case POSTGRESQL: {
                return new PostgreSQLIndexFiltersBuilder();
            }
        }
        throw new IllegalArgumentException("Unsupported database type.");
    }

    public void addFilter(IndexFilter filter) {
        this.filters.add(filter);
    }

    public abstract void addEqualFilter(String var1, Object var2, Type<?> var3);

    public abstract void addNotEqualFilter(String var1, Object var2, Type<?> var3);

    public void addVariablesFilters(VariableDto[] variables, boolean isPositiveFilter, boolean caseSensitive) {
        for (VariableDto variable : variables) {
            log.debug("Warto\u015b\u0107 sprawdzana: " + variable.getValue());
            if (variable.getPmidxValue() == null) {
                this.addNullFilter(variable.getId(), isPositiveFilter);
                continue;
            }
            if (variable.getType() == Types.STRING && !caseSensitive) {
                this.addCaseInsensitiveFilter(variable.getId(), variable.getPmidxValue(), isPositiveFilter);
                continue;
            }
            log.debug("Dodaj\u0119 zwyk\u0142y filtr");
            if (isPositiveFilter) {
                this.addEqualFilter(variable.getId(), variable.getPmidxValue(), variable.getType());
                continue;
            }
            this.addNotEqualFilter(variable.getId(), variable.getPmidxValue(), variable.getType());
        }
    }

    protected void addCaseInsensitiveFilter(String id, Object value, boolean isPositiveFilter) {
        log.debug("Dodaj\u0119 filtr typu 'CaseInsensitive' - wielko\u015b\u0107 liter NIE ma znaczenia w przeszukiwaniu po zmiennej: " + id);
        value = value != null ? value.toString().replace("%", "\\%").replace("_", "\\_") : null;
        this.addFilter((IndexFilter)new SimpleIndexFilter(id, value, isPositiveFilter ? FilterOperator.ILIKE : FilterOperator.NOTILIKE));
    }

    protected void addNullFilter(String id, boolean isPositiveFilter) {
        log.debug("Dodaj\u0119 null filtr dla pola o id: " + id);
        this.addFilter((IndexFilter)new SimpleIndexFilter(id, null, isPositiveFilter ? FilterOperator.ISNULL : FilterOperator.NOTNULL));
    }

    public void addFilters(List<SimpleFilter> filters) {
        this.filters.addAll(DataConverter.convertToSimpleIndexFilters(filters));
    }

    public List<IndexFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<IndexFilter> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexFiltersBuilder)) {
            return false;
        }
        IndexFiltersBuilder other = (IndexFiltersBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IndexFilter> this$filters = this.getFilters();
        List<IndexFilter> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexFiltersBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IndexFilter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "IndexFiltersBuilder(filters=" + String.valueOf(this.getFilters()) + ")";
    }
}

