PW.EventActions.register('eventaction.run-scheduled-task', function (context, taskName) {
    try {
        if (!taskName) {
            throw new Error("Required parameter 'taskName' is missing");
        }

        let endpoint = PlusWorkflow.getAbsolutePath("/plugin/com.suncode-cuf-components/scheduled-tasks/run?taskName=" + encodeURIComponent(taskName));

        setTimeout(this.async(() => {
            fetch(endpoint, {
                method: 'POST'
            })
                .then(this.async((async responses => {
                    const response = responses[0];
                    if (!response.ok) {
                        const errorText = await response.text();
                        throw new Error(errorText);
                    }
                    return response.text();
                })))
                .then(this.async((responses) => {
                    const response = responses[0];
                    this.fireEvent('success', {message: response && response.message ? response.message : response});
                }))
                .catch(this.async((error) => {
                    this.fireEvent('failure', {errorMessage: String(error && error.message ? error.message : error)});
                }));
        }), 0);
    } catch (error) {
        this.fireEvent('failure', {errorMessage: String(error && error.message ? error.message : error)});
    }
});